
/*
* File: main.c
* Author: Khaled Magdy
* I2C Slave Receiver
* PIC16F877A - Or Any Similar PIC MCU
* Different Parts Will Need Few Tweaking Before Running
*/
#include <xc.h>
#include "device_config.h"
#include "mcc.h"
#include <stdio.h>
//#include <ctype.h>
#include <stdlib.h>
#include <string.h>
//#include <assert.h>

//unsigned char RX_Data = 0x00;
   unsigned char Buff [40];
        volatile int point = 0;
//        unsigned char check;
//-----------[ Functions' Prototypes ]--------------
void I2C_Slave_Init(unsigned char);
void Lcd_Set_Cursor(char a, char b);

char flag1 = 0; 


//==================================================
void main(void) 
{

    LATE = 0x00;
    LATD = 0x00;
    LATA = 0x00;
    LATB = 0x00;
    LATC = 0x00;

    /**
    TRISx registers
    */
    TRISE = 0x0F;
    TRISC = 0xFF;
    TRISD = 0xFF;
    TRISB = 0b11000000;
//    TRISC = 0xBF;
//    TRISD = 0b11101011;

    /**
    ANSELx registers
    */
    ANSELD = 0xFF;
        ANSB0 = 0;
        ANSB1 = 0;
        ANSB2 = 0;
        ANSB3 = 0;
        ANSB4 = 0;
        ANSB5 = 0;
    ANSELE = 0x07;
    ANSELA = 0x3F;
    


    /**
    WPUx registers
    */
    WPUE = 0x00;
    WPUB = 0x00;
    OPTION_REGbits.nWPUEN = 1;


    /**
    APFCONx registers
    */
    APFCON = 0x00;
  
   Lcd_Init();
   
   char line = 1;


// front screen lcd 1 second
    Lcd_Clear();
//    Lcd_Set_Cursor(1,1);
//
//    Lcd_Write_String("INITIALISING...");
//    Lcd_Set_Cursor(2,1);
//    Lcd_Write_String("FIRMWARE V0.1");       
  
  I2C_Slave_Init(0x40); // Initiate I2C Slave With Address = 64 or 0x40
     
  while(1)
  {
 
      if(SSPSTATbits.S == 0 && SSPSTATbits.P == 1 && flag1 == 1) // last bit was a stop bit
      {
//          if(line == 0)
//          {
//              line = 1;
//          }
//          else line = 0;
//          
//          if(line == 0)
              Lcd_Clear();
          Lcd_Set_Cursor(1,1);
//          if(line == 1)
//          Lcd_Set_Cursor(2,1);
         
          Lcd_Write_String(&Buff);
          flag1 = 0;
          point = 0; 
          memset(&Buff,0,40); // this is necessary
//          Lcd_Set_Cursor(2,1);
//          check = 0;
      }
      if(flag1 == 1 && SSPSTATbits.P == 0) // do nothing
      {
      flag1 = 0; // do nothing but clear flag
      }
  }
//  return;
}
//----------------[ END OF MAIN ]-------------------
//==================================================
void __interrupt() ISR(void)
{
    
    
  if(SSPIF && point == 0)
  {
      flag1 = 1;
    if(!R_nW) // Slave Write (Receive)
    {
      char Dummy = SSPBUF; // Dummy Read
      CKP = 1; // Release The SCL Clock Line
      while(!BF); // Wait Until Completion
      Buff[point] = SSPBUF; // load the array
      point++; // move to next place in array

    }
      
  CKP = 1;   // Release The SCL Clock Line
  SSPIF = 0; // Clear The Interrupt Flag
  }
  
  
  
//    if(SSPIF && point > 0 && point < 17)
        if(SSPIF && point > 0 && SSPSTATbits.S == 1 && SSPSTATbits.P == 0) // start bit detected
  {
      flag1 = 1;
 
      while(!BF); // Wait Until Completion
                Buff[point] = SSPBUF; // load the array
          point++; // move to next place in array
//      RX_Data = SSPBUF; // Get the value of the current byte
//      check++;
      
  CKP = 1;   // Release The SCL Clock Line
  SSPIF = 0; // Clear The Interrupt Flag
  }

//          if(SSPIF && point > 0 && SSPSTATbits.S == 0 && SSPSTATbits.P == 1) // start bit detected
//  {
//      flag1 = 2;
// 
//      while(!BF); // Wait Until Completion
//                Buff[point] = SSPBUF; // load the array
//          point++; // move to next place in array
////      RX_Data = SSPBUF; // Get the value of the current byte
////      check++;
//      
//  CKP = 1;   // Release The SCL Clock Line
//  SSPIF = 0; // Clear The Interrupt Flag
//  }
  
}
//---------------[ I2C Routines ]-------------------
void I2C_Slave_Init(unsigned char Address)
{
  //---[ Configures The I2C In Slave Mode]---
  SSPADD = Address; // Set The I2C Slave Device Address
  SSPSTAT = 0x80;
  SSPCON = 0x36;
  SSPCON2 = 0x01;
  TRISC3 = 1; // SCL Set To Input
  TRISC4 = 1; // SDA Set To Input
  GIE = 1;    // Enable Interrupts
  PEIE = 1;
  SSPIF = 0;
  SSPIE = 1;
//  PCIE = 1;
}