/**
  System Interrupts Generated Driver File

  @Company:
    Microchip Technology Inc.

  @File Name:
    pin_manager.h

  @Summary:
    This is the generated manager file for the MPLAB(c) Code Configurator device.  This manager
    configures the pins direction, initial state, analog setting.

  @Description:
    This source file provides implementations for MPLAB(c) Code Configurator interrupts.
    Generation Information :
        Product Revision  :  MPLAB(c) Code Configurator - 3.16
        Device            :  PIC24FJ128GA010
        Version           :  1.02
    The generated drivers are tested against the following:
        Compiler          :  XC16 1.26
        MPLAB             :  MPLAB X 3.20

    Copyright (c) 2013 - 2015 released Microchip Technology Inc.  All rights reserved.

    Microchip licenses to you the right to use, modify, copy and distribute
    Software only when embedded on a Microchip microcontroller or digital signal
    controller that is integrated into your product or third party product
    (pursuant to the sublicense terms in the accompanying license agreement).

    You should refer to the license agreement accompanying this Software for
    additional information regarding your rights and obligations.

    SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
    EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, ANY WARRANTY OF
    MERCHANTABILITY, TITLE, NON-INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
    IN NO EVENT SHALL MICROCHIP OR ITS LICENSORS BE LIABLE OR OBLIGATED UNDER
    CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH OF WARRANTY, OR
    OTHER LEGAL EQUITABLE THEORY ANY DIRECT OR INDIRECT DAMAGES OR EXPENSES
    INCLUDING BUT NOT LIMITED TO ANY INCIDENTAL, SPECIAL, INDIRECT, PUNITIVE OR
    CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF PROCUREMENT OF
    SUBSTITUTE GOODS, TECHNOLOGY, SERVICES, OR ANY CLAIMS BY THIRD PARTIES
    (INCLUDING BUT NOT LIMITED TO ANY DEFENSE THEREOF), OR OTHER SIMILAR COSTS.

*/

#ifndef _PIN_MANAGER_H
#define _PIN_MANAGER_H
/**
    Section: Includes
*/
#include <xc.h>
/**
    Section: Device Pin Macros
*/
/**
  @Summary
    Sets the GPIO pin, RA0, high using LATA0.

  @Description
    Sets the GPIO pin, RA0, high using LATA0.

  @Preconditions
    The RA0 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RA0 high (1)
    LED_D3_SetHigh();
    </code>

*/
//#define LED_D3_SetHigh()          _LATA0 = 1
///**
//  @Summary
//    Sets the GPIO pin, RA0, low using LATA0.
//
//  @Description
//    Sets the GPIO pin, RA0, low using LATA0.
//
//  @Preconditions
//    The RA0 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA0 low (0)
//    LED_D3_SetLow();
//    </code>
//
//*/
//#define LED_D3_SetLow()           _LATA0 = 0
///**
//  @Summary
//    Toggles the GPIO pin, RA0, using LATA0.
//
//  @Description
//    Toggles the GPIO pin, RA0, using LATA0.
//
//  @Preconditions
//    The RA0 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Toggle RA0
//    LED_D3_Toggle();
//    </code>
//
//*/
//#define LED_D3_Toggle()           _LATA0 ^= 1
///**
//  @Summary
//    Reads the value of the GPIO pin, RA0.
//
//  @Description
//    Reads the value of the GPIO pin, RA0.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    uint16_t portValue;
//
//    // Read RA0
//    postValue = LED_D3_GetValue();
//    </code>
//
//*/
//#define LED_D3_GetValue()         _RA0
///**
//  @Summary
//    Configures the GPIO pin, RA0, as an input.
//
//  @Description
//    Configures the GPIO pin, RA0, as an input.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA0 as an input
//    LED_D3_SetDigitalInput();
//    </code>
//
//*/
//#define LED_D3_SetDigitalInput()  _TRISA0 = 1
///**
//  @Summary
//    Configures the GPIO pin, RA0, as an output.
//
//  @Description
//    Configures the GPIO pin, RA0, as an output.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA0 as an output
//    LED_D3_SetDigitalOutput();
//    </code>
//
//*/
//#define LED_D3_SetDigitalOutput() _TRISA0 = 0
///**
//  @Summary
//    Sets the GPIO pin, RA1, high using LATA1.
//
//  @Description
//    Sets the GPIO pin, RA1, high using LATA1.
//
//  @Preconditions
//    The RA1 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA1 high (1)
//    LED_D4_SetHigh();
//    </code>
//
//*/
//#define LED_D4_SetHigh()          _LATA1 = 1
///**
//  @Summary
//    Sets the GPIO pin, RA1, low using LATA1.
//
//  @Description
//    Sets the GPIO pin, RA1, low using LATA1.
//
//  @Preconditions
//    The RA1 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA1 low (0)
//    LED_D4_SetLow();
//    </code>
//
//*/
//#define LED_D4_SetLow()           _LATA1 = 0
///**
//  @Summary
//    Toggles the GPIO pin, RA1, using LATA1.
//
//  @Description
//    Toggles the GPIO pin, RA1, using LATA1.
//
//  @Preconditions
//    The RA1 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Toggle RA1
//    LED_D4_Toggle();
//    </code>
//
//*/
//#define LED_D4_Toggle()           _LATA1 ^= 1
///**
//  @Summary
//    Reads the value of the GPIO pin, RA1.
//
//  @Description
//    Reads the value of the GPIO pin, RA1.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    uint16_t portValue;
//
//    // Read RA1
//    postValue = LED_D4_GetValue();
//    </code>
//
//*/
//#define LED_D4_GetValue()         _RA1
///**
//  @Summary
//    Configures the GPIO pin, RA1, as an input.
//
//  @Description
//    Configures the GPIO pin, RA1, as an input.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA1 as an input
//    LED_D4_SetDigitalInput();
//    </code>
//
//*/
//#define LED_D4_SetDigitalInput()  _TRISA1 = 1
///**
//  @Summary
//    Configures the GPIO pin, RA1, as an output.
//
//  @Description
//    Configures the GPIO pin, RA1, as an output.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA1 as an output
//    LED_D4_SetDigitalOutput();
//    </code>
//
//*/
//#define LED_D4_SetDigitalOutput() _TRISA1 = 0
///**
//  @Summary
//    Sets the GPIO pin, RA2, high using LATA2.
//
//  @Description
//    Sets the GPIO pin, RA2, high using LATA2.
//
//  @Preconditions
//    The RA2 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA2 high (1)
//    LED_D5_SetHigh();
//    </code>
//
//*/
//#define LED_D5_SetHigh()          _LATA2 = 1
///**
//  @Summary
//    Sets the GPIO pin, RA2, low using LATA2.
//
//  @Description
//    Sets the GPIO pin, RA2, low using LATA2.
//
//  @Preconditions
//    The RA2 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA2 low (0)
//    LED_D5_SetLow();
//    </code>
//
//*/
//#define LED_D5_SetLow()           _LATA2 = 0
///**
//  @Summary
//    Toggles the GPIO pin, RA2, using LATA2.
//
//  @Description
//    Toggles the GPIO pin, RA2, using LATA2.
//
//  @Preconditions
//    The RA2 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Toggle RA2
//    LED_D5_Toggle();
//    </code>
//
//*/
//#define LED_D5_Toggle()           _LATA2 ^= 1
///**
//  @Summary
//    Reads the value of the GPIO pin, RA2.
//
//  @Description
//    Reads the value of the GPIO pin, RA2.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    uint16_t portValue;
//
//    // Read RA2
//    postValue = LED_D5_GetValue();
//    </code>
//
//*/
//#define LED_D5_GetValue()         _RA2
///**
//  @Summary
//    Configures the GPIO pin, RA2, as an input.
//
//  @Description
//    Configures the GPIO pin, RA2, as an input.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA2 as an input
//    LED_D5_SetDigitalInput();
//    </code>
//
//*/
//#define LED_D5_SetDigitalInput()  _TRISA2 = 1
///**
//  @Summary
//    Configures the GPIO pin, RA2, as an output.
//
//  @Description
//    Configures the GPIO pin, RA2, as an output.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA2 as an output
//    LED_D5_SetDigitalOutput();
//    </code>
//
//*/
//#define LED_D5_SetDigitalOutput() _TRISA2 = 0
///**
//  @Summary
//    Sets the GPIO pin, RA3, high using LATA3.
//
//  @Description
//    Sets the GPIO pin, RA3, high using LATA3.
//
//  @Preconditions
//    The RA3 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA3 high (1)
//    LED_D6_SetHigh();
//    </code>
//
//*/
//#define LED_D6_SetHigh()          _LATA3 = 1
///**
//  @Summary
//    Sets the GPIO pin, RA3, low using LATA3.
//
//  @Description
//    Sets the GPIO pin, RA3, low using LATA3.
//
//  @Preconditions
//    The RA3 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA3 low (0)
//    LED_D6_SetLow();
//    </code>
//
//*/
//#define LED_D6_SetLow()           _LATA3 = 0
///**
//  @Summary
//    Toggles the GPIO pin, RA3, using LATA3.
//
//  @Description
//    Toggles the GPIO pin, RA3, using LATA3.
//
//  @Preconditions
//    The RA3 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Toggle RA3
//    LED_D6_Toggle();
//    </code>
//
//*/
//#define LED_D6_Toggle()           _LATA3 ^= 1
///**
//  @Summary
//    Reads the value of the GPIO pin, RA3.
//
//  @Description
//    Reads the value of the GPIO pin, RA3.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    uint16_t portValue;
//
//    // Read RA3
//    postValue = LED_D6_GetValue();
//    </code>
//
//*/
//#define LED_D6_GetValue()         _RA3
///**
//  @Summary
//    Configures the GPIO pin, RA3, as an input.
//
//  @Description
//    Configures the GPIO pin, RA3, as an input.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA3 as an input
//    LED_D6_SetDigitalInput();
//    </code>
//
//*/
//#define LED_D6_SetDigitalInput()  _TRISA3 = 1
///**
//  @Summary
//    Configures the GPIO pin, RA3, as an output.
//
//  @Description
//    Configures the GPIO pin, RA3, as an output.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA3 as an output
//    LED_D6_SetDigitalOutput();
//    </code>
//
//*/
//#define LED_D6_SetDigitalOutput() _TRISA3 = 0
///**
//  @Summary
//    Sets the GPIO pin, RA4, high using LATA4.
//
//  @Description
//    Sets the GPIO pin, RA4, high using LATA4.
//
//  @Preconditions
//    The RA4 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA4 high (1)
//    LED_D7_SetHigh();
//    </code>
//
//*/
//#define LED_D7_SetHigh()          _LATA4 = 1
///**
//  @Summary
//    Sets the GPIO pin, RA4, low using LATA4.
//
//  @Description
//    Sets the GPIO pin, RA4, low using LATA4.
//
//  @Preconditions
//    The RA4 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA4 low (0)
//    LED_D7_SetLow();
//    </code>
//
//*/
//#define LED_D7_SetLow()           _LATA4 = 0
///**
//  @Summary
//    Toggles the GPIO pin, RA4, using LATA4.
//
//  @Description
//    Toggles the GPIO pin, RA4, using LATA4.
//
//  @Preconditions
//    The RA4 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Toggle RA4
//    LED_D7_Toggle();
//    </code>
//
//*/
//#define LED_D7_Toggle()           _LATA4 ^= 1
///**
//  @Summary
//    Reads the value of the GPIO pin, RA4.
//
//  @Description
//    Reads the value of the GPIO pin, RA4.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    uint16_t portValue;
//
//    // Read RA4
//    postValue = LED_D7_GetValue();
//    </code>
//
//*/
//#define LED_D7_GetValue()         _RA4
///**
//  @Summary
//    Configures the GPIO pin, RA4, as an input.
//
//  @Description
//    Configures the GPIO pin, RA4, as an input.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA4 as an input
//    LED_D7_SetDigitalInput();
//    </code>
//
//*/
//#define LED_D7_SetDigitalInput()  _TRISA4 = 1
///**
//  @Summary
//    Configures the GPIO pin, RA4, as an output.
//
//  @Description
//    Configures the GPIO pin, RA4, as an output.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA4 as an output
//    LED_D7_SetDigitalOutput();
//    </code>
//
//*/
//#define LED_D7_SetDigitalOutput() _TRISA4 = 0
///**
//  @Summary
//    Sets the GPIO pin, RA5, high using LATA5.
//
//  @Description
//    Sets the GPIO pin, RA5, high using LATA5.
//
//  @Preconditions
//    The RA5 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA5 high (1)
//    LED_D8_SetHigh();
//    </code>
//
//*/
//#define LED_D8_SetHigh()          _LATA5 = 1
///**
//  @Summary
//    Sets the GPIO pin, RA5, low using LATA5.
//
//  @Description
//    Sets the GPIO pin, RA5, low using LATA5.
//
//  @Preconditions
//    The RA5 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA5 low (0)
//    LED_D8_SetLow();
//    </code>
//
//*/
//#define LED_D8_SetLow()           _LATA5 = 0
///**
//  @Summary
//    Toggles the GPIO pin, RA5, using LATA5.
//
//  @Description
//    Toggles the GPIO pin, RA5, using LATA5.
//
//  @Preconditions
//    The RA5 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Toggle RA5
//    LED_D8_Toggle();
//    </code>
//
//*/
//#define LED_D8_Toggle()           _LATA5 ^= 1
///**
//  @Summary
//    Reads the value of the GPIO pin, RA5.
//
//  @Description
//    Reads the value of the GPIO pin, RA5.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    uint16_t portValue;
//
//    // Read RA5
//    postValue = LED_D8_GetValue();
//    </code>
//
//*/
//#define LED_D8_GetValue()         _RA5
///**
//  @Summary
//    Configures the GPIO pin, RA5, as an input.
//
//  @Description
//    Configures the GPIO pin, RA5, as an input.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA5 as an input
//    LED_D8_SetDigitalInput();
//    </code>
//
//*/
//#define LED_D8_SetDigitalInput()  _TRISA5 = 1
///**
//  @Summary
//    Configures the GPIO pin, RA5, as an output.
//
//  @Description
//    Configures the GPIO pin, RA5, as an output.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA5 as an output
//    LED_D8_SetDigitalOutput();
//    </code>
//
//*/
//#define LED_D8_SetDigitalOutput() _TRISA5 = 0
///**
//  @Summary
//    Sets the GPIO pin, RA6, high using LATA6.
//
//  @Description
//    Sets the GPIO pin, RA6, high using LATA6.
//
//  @Preconditions
//    The RA6 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA6 high (1)
//    LED_D9_SetHigh();
//    </code>
//
//*/
//#define LED_D9_SetHigh()          _LATA6 = 1
///**
//  @Summary
//    Sets the GPIO pin, RA6, low using LATA6.
//
//  @Description
//    Sets the GPIO pin, RA6, low using LATA6.
//
//  @Preconditions
//    The RA6 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA6 low (0)
//    LED_D9_SetLow();
//    </code>
//
//*/
//#define LED_D9_SetLow()           _LATA6 = 0
///**
//  @Summary
//    Toggles the GPIO pin, RA6, using LATA6.
//
//  @Description
//    Toggles the GPIO pin, RA6, using LATA6.
//
//  @Preconditions
//    The RA6 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Toggle RA6
//    LED_D9_Toggle();
//    </code>
//
//*/
//#define LED_D9_Toggle()           _LATA6 ^= 1
///**
//  @Summary
//    Reads the value of the GPIO pin, RA6.
//
//  @Description
//    Reads the value of the GPIO pin, RA6.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    uint16_t portValue;
//
//    // Read RA6
//    postValue = LED_D9_GetValue();
//    </code>
//
//*/
//#define LED_D9_GetValue()         _RA6
///**
//  @Summary
//    Configures the GPIO pin, RA6, as an input.
//
//  @Description
//    Configures the GPIO pin, RA6, as an input.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA6 as an input
//    LED_D9_SetDigitalInput();
//    </code>
//
//*/
//#define LED_D9_SetDigitalInput()  _TRISA6 = 1
///**
//  @Summary
//    Configures the GPIO pin, RA6, as an output.
//
//  @Description
//    Configures the GPIO pin, RA6, as an output.
//
//  @Preconditions
//    None.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Sets the RA6 as an output
//    LED_D9_SetDigitalOutput();
//    </code>
//
//*/
//#define LED_D9_SetDigitalOutput() _TRISA6 = 0
///**
//  @Summary
//    Sets the GPIO pin, RA7, high using LATA7.
//
//  @Description
//    Sets the GPIO pin, RA7, high using LATA7.
//
//  @Preconditions
//    The RA7 must be set to an output.
//
//  @Returns
//    None.
//
//  @Param
//    None.
//
//  @Example
//    <code>
//    // Set RA7 high (1)
//    SW_S5_SetHigh();
//    </code>
//
//*/
#define SW_S5_SetHigh()          _LATB13 = 1
/**
  @Summary
    Sets the GPIO pin, RA7, low using LATA7.

  @Description
    Sets the GPIO pin, RA7, low using LATA7.

  @Preconditions
    The RA7 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RA7 low (0)
    SW_S5_SetLow();
    </code>

*/
#define SW_S5_SetLow()           _LATB13 = 0
/**
  @Summary
    Toggles the GPIO pin, RA7, using LATA7.

  @Description
    Toggles the GPIO pin, RA7, using LATA7.

  @Preconditions
    The RA7 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Toggle RA7
    SW_S5_Toggle();
    </code>

*/
#define SW_S5_Toggle()           _LATB13 ^= 1
/**
  @Summary
    Reads the value of the GPIO pin, RA7.

  @Description
    Reads the value of the GPIO pin, RA7.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    uint16_t portValue;

    // Read RA7
    postValue = SW_S5_GetValue();
    </code>

*/
#define SW_S5_GetValue()         _RB13
/**
  @Summary
    Configures the GPIO pin, RA7, as an input.

  @Description
    Configures the GPIO pin, RA7, as an input.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RA7 as an input
    SW_S5_SetDigitalInput();
    </code>

*/
#define SW_S5_SetDigitalInput()  _TRISB13 = 1
/**
  @Summary
    Configures the GPIO pin, RA7, as an output.

  @Description
    Configures the GPIO pin, RA7, as an output.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RA7 as an output
    SW_S5_SetDigitalOutput();
    </code>

*/
#define SW_S5_SetDigitalOutput() _TRISB13 = 0
/**
  @Summary
    Sets the GPIO pin, RD13, high using LATD13.

  @Description
    Sets the GPIO pin, RD13, high using LATD13.

  @Preconditions
    The RD13 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RD13 high (1)
    SW_S4_SetHigh();
    </code>

*/
#define SW_S4_SetHigh()          _LATB14 = 1
/**
  @Summary
    Sets the GPIO pin, RD13, low using LATD13.

  @Description
    Sets the GPIO pin, RD13, low using LATD13.

  @Preconditions
    The RD13 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RD13 low (0)
    SW_S4_SetLow();
    </code>

*/
#define SW_S4_SetLow()           _LATB14 = 0
/**
  @Summary
    Toggles the GPIO pin, RD13, using LATD13.

  @Description
    Toggles the GPIO pin, RD13, using LATD13.

  @Preconditions
    The RD13 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Toggle RD13
    SW_S4_Toggle();
    </code>

*/
#define SW_S4_Toggle()           _LATB14 ^= 1
/**
  @Summary
    Reads the value of the GPIO pin, RD13.

  @Description
    Reads the value of the GPIO pin, RD13.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    uint16_t portValue;

    // Read RD13
    postValue = SW_S4_GetValue();
    </code>

*/
#define SW_S4_GetValue()         _RB14
/**
  @Summary
    Configures the GPIO pin, RD13, as an input.

  @Description
    Configures the GPIO pin, RD13, as an input.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RD13 as an input
    SW_S4_SetDigitalInput();
    </code>

*/
#define SW_S4_SetDigitalInput()  _TRISB14 = 1
/**
  @Summary
    Configures the GPIO pin, RD13, as an output.

  @Description
    Configures the GPIO pin, RD13, as an output.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RD13 as an output
    SW_S4_SetDigitalOutput();
    </code>

*/
#define SW_S4_SetDigitalOutput() _TRISB14 = 0
/**
  @Summary
    Sets the GPIO pin, RD6, high using LATD6.

  @Description
    Sets the GPIO pin, RD6, high using LATD6.

  @Preconditions
    The RD6 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RD6 high (1)
    SW_S3_SetHigh();
    </code>

*/
#define SW_S3_SetHigh()          _LATB11 = 1
/**
  @Summary
    Sets the GPIO pin, RD6, low using LATD6.

  @Description
    Sets the GPIO pin, RD6, low using LATD6.

  @Preconditions
    The RD6 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RD6 low (0)
    SW_S3_SetLow();
    </code>

*/
#define SW_S3_SetLow()           _LATB11 = 0
/**
  @Summary
    Toggles the GPIO pin, RD6, using LATD6.

  @Description
    Toggles the GPIO pin, RD6, using LATD6.

  @Preconditions
    The RD6 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Toggle RD6
    SW_S3_Toggle();
    </code>

*/
#define SW_S3_Toggle()           _LATB11 ^= 1
/**
  @Summary
    Reads the value of the GPIO pin, RD6.

  @Description
    Reads the value of the GPIO pin, RD6.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    uint16_t portValue;

    // Read RD6
    postValue = SW_S3_GetValue();
    </code>

*/
#define SW_S3_GetValue()         _RB11
/**
  @Summary
    Configures the GPIO pin, RD6, as an input.

  @Description
    Configures the GPIO pin, RD6, as an input.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RD6 as an input
    SW_S3_SetDigitalInput();
    </code>

*/
#define SW_S3_SetDigitalInput()  _TRISB11 = 1
/**
  @Summary
    Configures the GPIO pin, RD6, as an output.

  @Description
    Configures the GPIO pin, RD6, as an output.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RD6 as an output
    SW_S3_SetDigitalOutput();
    </code>

*/
#define SW_S3_SetDigitalOutput() _TRISB11 = 0
/**
  @Summary
    Sets the GPIO pin, RD7, high using LATD7.

  @Description
    Sets the GPIO pin, RD7, high using LATD7.

  @Preconditions
    The RD7 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RD7 high (1)
    SW_S6_SetHigh();
    </code>

*/
#define SW_S6_SetHigh()          _LATB15 = 1
/**
  @Summary
    Sets the GPIO pin, RD7, low using LATD7.

  @Description
    Sets the GPIO pin, RD7, low using LATD7.

  @Preconditions
    The RD7 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RD7 low (0)
    SW_S6_SetLow();
    </code>

*/
#define SW_S6_SetLow()           _LATB15 = 0
/**
  @Summary
    Toggles the GPIO pin, RD7, using LATD7.

  @Description
    Toggles the GPIO pin, RD7, using LATD7.

  @Preconditions
    The RD7 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Toggle RD7
    SW_S6_Toggle();
    </code>

*/
#define SW_S6_Toggle()           _LATB15 ^= 1
/**
  @Summary
    Reads the value of the GPIO pin, RD7.

  @Description
    Reads the value of the GPIO pin, RD7.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    uint16_t portValue;

    // Read RD7
    postValue = SW_S6_GetValue();
    </code>

*/
#define SW_S6_GetValue()         _RB15
/**
  @Summary
    Configures the GPIO pin, RD7, as an input.

  @Description
    Configures the GPIO pin, RD7, as an input.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RD7 as an input
    SW_S6_SetDigitalInput();
    </code>

*/
#define SW_S6_SetDigitalInput()  _TRISB15 = 1
/**
  @Summary
    Configures the GPIO pin, RD7, as an output.

  @Description
    Configures the GPIO pin, RD7, as an output.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RD7 as an output
    SW_S6_SetDigitalOutput();
    </code>

*/
#define SW_S6_SetDigitalOutput() _TRISB15 = 0
/**
  @Summary
    Sets the GPIO pin, RE8, high using LATE8.

  @Description
    Sets the GPIO pin, RE8, high using LATE8.

  @Preconditions
    The RE8 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RE8 high (1)
    I2C_ALERT_SetHigh();
    </code>

*/






#define I2C_ALERT_SetHigh()          _LATB4 = 1
/**
  @Summary
    Sets the GPIO pin, RE8, low using LATE8.

  @Description
    Sets the GPIO pin, RE8, low using LATE8.

  @Preconditions
    The RE8 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RE8 low (0)
    I2C_ALERT_SetLow();
    </code>

*/
#define I2C_ALERT_SetLow()           _LATB4 = 0
/**
  @Summary
    Toggles the GPIO pin, RE8, using LATE8.

  @Description
    Toggles the GPIO pin, RE8, using LATE8.

  @Preconditions
    The RE8 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Toggle RE8
    I2C_ALERT_Toggle();
    </code>

*/
#define I2C_ALERT_Toggle()           _LATB4 ^= 1
/**
  @Summary
    Reads the value of the GPIO pin, RE8.

  @Description
    Reads the value of the GPIO pin, RE8.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    uint16_t portValue;

    // Read RE8
    postValue = I2C_ALERT_GetValue();
    </code>

*/
#define I2C_ALERT_GetValue()         _RB4
/**
  @Summary
    Configures the GPIO pin, RE8, as an input.

  @Description
    Configures the GPIO pin, RE8, as an input.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RE8 as an input
    I2C_ALERT_SetDigitalInput();
    </code>

*/
#define I2C_ALERT_SetDigitalInput()  _TRISB4 = 1
/**
  @Summary
    Configures the GPIO pin, RE8, as an output.

  @Description
    Configures the GPIO pin, RE8, as an output.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RE8 as an output
    I2C_ALERT_SetDigitalOutput();
    </code>

*/
#define I2C_ALERT_SetDigitalOutput() _TRISB4 = 0
/**
  @Summary
    Sets the GPIO pin, RE9, high using LATE9.

  @Description
    Sets the GPIO pin, RE9, high using LATE9.

  @Preconditions
    The RE9 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RE9 high (1)
    WAKE_SetHigh();
    </code>

*/

#define WAKE_SetHigh()          _LATB5 = 1
/**
  @Summary
    Sets the GPIO pin, RE9, low using LATE9.

  @Description
    Sets the GPIO pin, RE9, low using LATE9.

  @Preconditions
    The RE9 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Set RE9 low (0)
    WAKE_SetLow();
    </code>

*/
#define WAKE_SetLow()           _LATB5 = 0
/**
  @Summary
    Toggles the GPIO pin, RE9, using LATE9.

  @Description
    Toggles the GPIO pin, RE9, using LATE9.

  @Preconditions
    The RE9 must be set to an output.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Toggle RE9
    WAKE_Toggle();
    </code>

*/
#define WAKE_Toggle()           _LATB5 ^= 1
/**
  @Summary
    Reads the value of the GPIO pin, RE9.

  @Description
    Reads the value of the GPIO pin, RE9.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    uint16_t portValue;

    // Read RE9
    postValue = WAKE_GetValue();
    </code>

*/
#define WAKE_GetValue()         _RB5
/**
  @Summary
    Configures the GPIO pin, RE9, as an input.

  @Description
    Configures the GPIO pin, RE9, as an input.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RE9 as an input
    WAKE_SetDigitalInput();
    </code>

*/
#define WAKE_SetDigitalInput()  _TRISB5 = 1
/**
  @Summary
    Configures the GPIO pin, RE9, as an output.

  @Description
    Configures the GPIO pin, RE9, as an output.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    // Sets the RE9 as an output
    WAKE_SetDigitalOutput();
    </code>

*/
#define WAKE_SetDigitalOutput() _TRISB5 = 0

/**
    Section: Function Prototypes
*/
/**
  @Summary
    Configures the pin settings of the PIC24FJ128GA010

  @Description
    This is the generated manager file for the MPLAB(c) Code Configurator device.  This manager
    configures the pins direction, initial state, analog setting.

  @Preconditions
    None.

  @Returns
    None.

  @Param
    None.

  @Example
    <code>
    void SYSTEM_Initialize(void)
    {
        // Other initializers are called from this function
        PIN_MANAGER_Initialize();
    }
    </code>

*/
void PIN_MANAGER_Initialize(void);

#endif
