
#include "Console.h"
#include "GenericTypeDefs.h"
#include "RadioDriverDefs.h"
#include "compiler.h"

/************************ VARIABLES ********************************/
    ROM unsigned char CharacterArray[]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};


    void ConsoleInit(void)
    {

            U2BRG   = (CLOCK_FREQ/2/16)/BAUD_RATE-1;
				//program the baud rate
            IFS1bits.U2RXIF = 0;
				//reset the UART 2 Receive interrupt
		//	Temp = U2RXREG;
            U2STA  = 0;
				//Reset the UART 2 status bits
            U2MODE = 0b0000000010000000;
				//Set the bit UEN1 and UEN0 to value '01'
            U2MODEbits.UARTEN = 1;
				//set UARTEN to 1
            U2STAbits.UTXEN = 1;
				//set UTXEN bit in UART Status register
    }
    

    void ConsolePutROMString(ROM char* str)
    {
        BYTE c;
    
        while( (c = *str++) )
        {
            ConsolePut(c); 
			//put character by character on screen (transmit using usart)
        }
    }
    
    
    
    void ConsolePut(BYTE c)
    {
			//Read from the console the byte/string that is entered
    if(c == 19)
		ConsolePutROMString((ROM char *)"(Ctrl + S)");
		//System Status
	else if(c == 18)
		ConsolePutROMString((ROM char *)"(Ctrl + R)");
		//Receive Mode - Default Receive Mode (Verbose)
	else if(c == 20)
		ConsolePutROMString((ROM char *)"(Ctrl + T)");
		//Transmit Precoded Packet continuously
	else if(c == 24)
		ConsolePutROMString((ROM char *)"(Ctrl + X)");
		//Reset MRF24J40
	else if(c == 26)
		ConsolePutROMString((ROM char *)"(Ctrl + Z)");
		//Exit + MainMenu
	else
		{
        while(U2STAbits.TRMT == 0);
			//wait until previous transmission is complete or done
        U2TXREG = c;
			//write the data byte to lower byte of TXREG
		}
    }
    

    void PrintChar(BYTE toPrint)
    {
        BYTE PRINT_VAR;
        PRINT_VAR = toPrint;
        toPrint = (toPrint>>4)&0x0F;
        ConsolePut(CharacterArray[toPrint]);
        toPrint = (PRINT_VAR)&0x0F;
        ConsolePut(CharacterArray[toPrint]);
        return;
    }

    BYTE ConsoleGet(void)
	{
    	char Temp;

	    while(IFS1bits.U2RXIF == 0);
    	Temp = U2RXREG;
		//read the input value in to temp
		IFS1bits.U2RXIF = 0;
		if(U2STAbits.URXDA)
			{
			Temp = U2RXREG;
			return Temp;
			}
		else
    		return Temp;
		//return the value to the calling function
	}



BYTE ConsoleInput(void)
{
    BYTE in;
    
    while(!ConsoleIsGetReady());
    
    in = ConsoleGet();
    ConsolePut(in);
    return in;
}


void PrintDigit(BYTE toPrint)
{
    BYTE tmp1, tmp2, tmp3;
    
    tmp1 = toPrint / 100 ;
    if( tmp1 == 0 )
    {
//        ConsolePut(' ');
    }
    else
    {
        ConsolePut('0' + tmp1 );
    }
    
    tmp3 = toPrint % 100;
    tmp2 = tmp3 / 10;
    if( tmp2 == 0 && tmp1 == 0 )
    {
//        ConsolePut(' ');
    }
    else
    {
        ConsolePut('0' + tmp2 );
    }
    
    tmp1 = tmp3 % 10;
    ConsolePut('0' + tmp1);
}


void PrintDigitW(WORD toPrint)
{
    BYTE tmp1, tmp2, tmp3, tmp4, tmp5;
    
    tmp1 = toPrint / 10000 ;
    if( tmp1 == 0 )
    {
//        ConsolePut(' ');
    }
    else
    {
        ConsolePut('0' + tmp1 );
    }
    
    toPrint = toPrint % 10000;
    tmp2 = toPrint / 1000;
    if( tmp2 == 0 && tmp1 == 0 )
    {
 //       ConsolePut(' ');
    }
    else
    {
        ConsolePut('0' + tmp2 );
    }
    toPrint = toPrint % 1000;
    tmp3 = toPrint / 100;
    if( tmp3 == 0 && tmp2 == 0 && tmp1 == 0 )
    {
  //      ConsolePut(' ');
    }
    else
    {
        ConsolePut('0' + tmp3 );
    }
    toPrint = toPrint % 100;
    tmp4 = toPrint / 10;
    if( tmp4 == 0 && tmp3 == 0 && tmp2 == 0 && tmp1 == 0 )
    {
  //      ConsolePut(' ');
    }
    else
    {
        ConsolePut('0' + tmp4 );
    }

    tmp5 = toPrint % 10;
    ConsolePut('0' + tmp5);
}


