
#include "FHSS.h"
#include "GenericTypeDefs.h"
#include "compiler.h"
#include "RadioDriverDefs.h"
#include "spi.h"
#include "Console.h"
#include "MRF89XA.h"

#define NUM_CHANNELS 50
#define L_NUM_CHANNELS 70


//#define VERBOSE

//50 hopping Channels {R, P, S, BAND}
const ROM freq_t ch_0  = { 119,  99, 27, 0 };	//903.24
const ROM freq_t ch_1  = { 119,  99, 31, 0 };	//903.72
const ROM freq_t ch_2  = { 119,  99, 35, 0 };	//904.20
const ROM freq_t ch_3  = { 119,  99, 39, 0 };	//904.68
const ROM freq_t ch_4  = { 119,  99, 43, 0 };	//905.16
const ROM freq_t ch_5  = { 119,  99, 47, 0 };	//905.64
const ROM freq_t ch_6  = { 119,  99, 51, 0 };	//906.12
const ROM freq_t ch_7  = { 119,  99, 55, 0 };	//906.60
const ROM freq_t ch_8  = { 119,  99, 59, 0 };	//907.08
const ROM freq_t ch_9  = { 119,  99, 63, 0 };	//907.56
const ROM freq_t ch_10 = { 119,  99, 67, 0 };	//908.04
const ROM freq_t ch_11 = { 119,  99, 71, 0 };	//908.52
const ROM freq_t ch_12 = { 119, 100,  0, 0 };	//909.00
const ROM freq_t ch_13 = { 119, 100,  4, 0 };	//909.48
const ROM freq_t ch_14 = { 119, 100,  8, 0 };	//909.96
const ROM freq_t ch_15 = { 119, 100, 12, 0 };	//910.44
const ROM freq_t ch_16 = { 119, 100, 16, 0 };	//910.92
const ROM freq_t ch_17 = { 119, 100, 20, 0 };	//911.40
const ROM freq_t ch_18 = { 119, 100, 24, 0 };	//911.88
const ROM freq_t ch_19 = { 119, 100, 28, 0 };	//912.36
const ROM freq_t ch_20 = { 119, 100, 32, 0 };	//912.84
const ROM freq_t ch_21 = { 119, 100, 36, 0 };	//913.32
const ROM freq_t ch_22 = { 119, 100, 40, 0 };	//913.80
const ROM freq_t ch_23 = { 119, 100, 44, 0 };	//914.28
const ROM freq_t ch_24 = { 119, 100, 48, 0 };	//914.76
const ROM freq_t ch_25 = { 119, 100, 52, 1 };	//915.24
const ROM freq_t ch_26 = { 119, 100, 56, 1 };	//915.72
const ROM freq_t ch_27 = { 119, 100, 60, 1 };	//916.20
const ROM freq_t ch_28 = { 119, 100, 64, 1 };	//916.68
const ROM freq_t ch_29 = { 119, 100, 68, 1 };	//917.16
const ROM freq_t ch_30 = { 119, 100, 72, 1 };	//917.64
const ROM freq_t ch_31 = { 119, 101,  1, 1 };	//918.12
const ROM freq_t ch_32 = { 119, 101,  5, 1 };	//918.60
const ROM freq_t ch_33 = { 119, 101,  9, 1 };	//919.08
const ROM freq_t ch_34 = { 119, 101, 13, 1 };	//919.56
const ROM freq_t ch_35 = { 119, 101, 17, 1 };	//920.04
const ROM freq_t ch_36 = { 119, 101, 21, 1 };	//920.52
const ROM freq_t ch_37 = { 119, 101, 25, 1 };	//921.00
const ROM freq_t ch_38 = { 119, 101, 29, 1 };	//921.48
const ROM freq_t ch_39 = { 119, 101, 33, 1 };	//921.96
const ROM freq_t ch_40 = { 119, 101, 37, 1 };	//922.44
const ROM freq_t ch_41 = { 119, 101, 41, 1 };	//922.92
const ROM freq_t ch_42 = { 119, 101, 45, 1 };	//923.40
const ROM freq_t ch_43 = { 119, 101, 49, 1 };	//923.88
const ROM freq_t ch_44 = { 119, 101, 53, 1 };	//924.36
const ROM freq_t ch_45 = { 119, 101, 57, 1 };	//924.84
const ROM freq_t ch_46 = { 119, 101, 61, 1 };	//925.32
const ROM freq_t ch_47 = { 119, 101, 65, 1 };	//925.80
const ROM freq_t ch_48 = { 119, 101, 69, 1 };	//926.28
const ROM freq_t ch_49 = { 119, 101, 73, 1 };	//926.76


//Hopping Order
static const ROM freq_t * freqs_P[NUM_CHANNELS] = {
	&ch_22,		// 0
	&ch_20,		// 1
	&ch_0,		// 2
	&ch_6,		// 3
	&ch_46,		// 4
	&ch_23,		// 5
	&ch_47,		// 6
	&ch_49,		// 7
	&ch_37,		// 8
	&ch_39,		// 9
	&ch_41,		// 10
	&ch_24,		// 11
	&ch_4,		// 12
	&ch_34,		// 13
	&ch_36,		// 14
	&ch_16,		// 15
	&ch_27,		// 16
	&ch_48,		// 17
	&ch_40,		// 18
	&ch_11,		// 19
	&ch_10,		// 20
	&ch_32,		// 21
	&ch_21,		// 22
	&ch_28,		// 23
	&ch_18,		// 24
	&ch_5,		// 25
	&ch_29,		// 26
	&ch_44,		// 27
	&ch_19,		// 28
	&ch_12,		// 29
	&ch_1,		// 30
	&ch_33,		// 31
	&ch_35,		// 32
	&ch_8,		// 33
	&ch_43,		// 34
	&ch_30,		// 35
	&ch_13,		// 36
	&ch_42,		// 37
	&ch_9,		// 38
	&ch_3,		// 39
	&ch_31,		// 40
	&ch_14,		// 41
	&ch_38,		// 42
	&ch_2,		// 43
	&ch_25,		// 44
	&ch_7,		// 45
	&ch_26,		// 46
	&ch_15,		// 47
	&ch_17,		// 48
	&ch_45,		// 49
};

//70 hopping Channels {R, P, S, BAND}
const ROM freq_t l_ch_0  = {  90,  71, 54, 2 };	//863.05
const ROM freq_t l_ch_1  = { 168, 134,  5, 2 };	//863.14
const ROM freq_t l_ch_2  = {  95,  75, 55, 2 };	//863.25
const ROM freq_t l_ch_3  = { 154, 122, 68, 2 };	//863.34
const ROM freq_t l_ch_4  = { 156, 124, 39, 2 };	//863.44
const ROM freq_t l_ch_5  = { 127, 101, 26, 2 };	//863.55
const ROM freq_t l_ch_6  = { 164, 130, 71, 2 };	//863.65
const ROM freq_t l_ch_7  = { 114,  90, 73, 2 };	//863.74
const ROM freq_t l_ch_8  = {  95,  75, 59, 2 };	//863.85
const ROM freq_t l_ch_9  = { 169, 134, 74, 2 };	//863.91
const ROM freq_t l_ch_10 = { 169, 135,  1, 2 };	//864.08
const ROM freq_t l_ch_11 = {  95,  75, 61, 2 };	//864.15
const ROM freq_t l_ch_12 = { 114,  91,  2, 2 };	//864.25
const ROM freq_t l_ch_13 = { 164, 131,  4, 2 };	//864.34
const ROM freq_t l_ch_14 = { 127, 101, 34, 2 };	//864.45
const ROM freq_t l_ch_15 = { 156, 124, 51, 2 };	//864.55
const ROM freq_t l_ch_16 = { 154, 123,  7, 2 };	//864.65
const ROM freq_t l_ch_17 = {  95,  75, 65, 2 };	//864.75
const ROM freq_t l_ch_18 = { 168, 134, 25, 2 };	//864.85
const ROM freq_t l_ch_19 = {  90,  71, 66, 2 };	//864.94
const ROM freq_t l_ch_20 = {  95,  75, 67, 2 };	//865.05
const ROM freq_t l_ch_21 = { 162, 129, 43, 2 };	//865.14
const ROM freq_t l_ch_22 = { 149, 119, 13, 2 };	//865.24
const ROM freq_t l_ch_23 = { 127, 101, 42, 2 };	//865.35
const ROM freq_t l_ch_24 = { 148, 118, 30, 2 };	//865.44
const ROM freq_t l_ch_25 = { 157, 125, 47, 2 };	//865.54
const ROM freq_t l_ch_26 = {  95,  75, 71, 2 };	//865.65
const ROM freq_t l_ch_27 = { 106,  84, 58, 2 };	//865.74
const ROM freq_t l_ch_28 = { 108,  86, 29, 2 };	//865.84
const ROM freq_t l_ch_29 = {  95,  75, 73, 2 };	//865.95
const ROM freq_t l_ch_30 = { 168, 134, 39, 2 };	//866.04
const ROM freq_t l_ch_31 = { 153, 122, 38, 2 };	//866.15
const ROM freq_t l_ch_32 = { 127, 101, 50, 2 };	//866.25
const ROM freq_t l_ch_33 = {  97,  77, 46, 2 };	//866.35
const ROM freq_t l_ch_34 = { 146, 116, 70, 2 };	//866.44
const ROM freq_t l_ch_35 = {  95,  76,  2, 2 };	//866.55
const ROM freq_t l_ch_36 = { 162, 129, 60, 2 };	//866.65
const ROM freq_t l_ch_37 = {  88,  70, 32, 2 };	//866.75
const ROM freq_t l_ch_38 = {  95,  76,  4, 2 };	//866.85
const ROM freq_t l_ch_39 = {  82,  65, 47, 2 };	//866.95
const ROM freq_t l_ch_40 = {  84,  67, 18, 2 };	//867.05
const ROM freq_t l_ch_41 = { 127, 101, 58, 2 };	//867.15
const ROM freq_t l_ch_42 = { 163, 130, 52, 2 };	//867.25
const ROM freq_t l_ch_43 = { 158, 126, 52, 2 };	//867.35
const ROM freq_t l_ch_44 = {  95,  76,  8, 2 };	//867.45
const ROM freq_t l_ch_45 = { 145, 116, 21, 2 };	//867.55
const ROM freq_t l_ch_46 = { 145, 116, 22, 2 };	//867.65
const ROM freq_t l_ch_47 = {  95,  76, 10, 2 };	//867.75
const ROM freq_t l_ch_48 = { 100,  80, 12, 2 };	//867.85
const ROM freq_t l_ch_49 = { 112,  89, 61, 2 };	//867.95
const ROM freq_t l_ch_50 = { 127, 101, 66, 2 };	//868.05
const ROM freq_t l_ch_51 = { 169, 135, 49, 2 };	//868.15
const ROM freq_t l_ch_52 = { 165, 132, 34, 2 };	//868.25
const ROM freq_t l_ch_53 = {  95,  76, 14, 2 };	//868.35
const ROM freq_t l_ch_54 = { 109,  87, 34, 2 };	//868.45
const ROM freq_t l_ch_55 = { 154, 123, 49, 2 };	//868.55
const ROM freq_t l_ch_56 = {  95,  76, 16, 2 };	//868.65
const ROM freq_t l_ch_57 = {  96,  77,  2, 2 };	//868.75
const ROM freq_t l_ch_58 = {  94,  75, 32, 2 };	//868.85
const ROM freq_t l_ch_59 = { 127, 101, 74, 2 };	//868.95
const ROM freq_t l_ch_60 = { 153, 122, 69, 2 };	//869.05
const ROM freq_t l_ch_61 = { 150, 120, 39, 2 };	//869.15
const ROM freq_t l_ch_62 = {  95,  76, 20, 2 };	//869.25
const ROM freq_t l_ch_63 = { 147, 118, 10, 2 };	//869.35
const ROM freq_t l_ch_64 = { 110,  88, 27, 2 };	//869.45
const ROM freq_t l_ch_65 = {  95,  76, 22, 2 };	//869.55
const ROM freq_t l_ch_66 = { 157, 126, 17, 2 };	//869.65
const ROM freq_t l_ch_67 = { 167, 134, 22, 2 };	//869.75
const ROM freq_t l_ch_68 = { 127, 102,  7, 2 };	//869.85
const ROM freq_t l_ch_69 = { 166, 133, 39, 2 };	//869.95


//Hopping Order
static const ROM freq_t * l_freqs_P[L_NUM_CHANNELS] = {
	&l_ch_45,
	&l_ch_36,
	&l_ch_57,
	&l_ch_44,
	&l_ch_48,
	&l_ch_19,
	&l_ch_49,
	&l_ch_53,
	&l_ch_67,
 	&l_ch_1,
	&l_ch_17,
	&l_ch_51,
	&l_ch_16,
 	&l_ch_4,
 	&l_ch_9,
	&l_ch_41,
	&l_ch_62,
	&l_ch_65,
	&l_ch_40,
	&l_ch_63,
	&l_ch_46,
	&l_ch_42,
	&l_ch_32,
	&l_ch_43,
	&l_ch_20,
	&l_ch_35,
	&l_ch_12,
	&l_ch_47,
	&l_ch_5,
	&l_ch_24,
	&l_ch_55,
	&l_ch_14,
	&l_ch_60,
	&l_ch_11,
	&l_ch_33,
	&l_ch_66,
	&l_ch_38,
	&l_ch_10,
	&l_ch_27,
	&l_ch_68,
	&l_ch_50,
	&l_ch_22,
	&l_ch_34,
	&l_ch_39,
	&l_ch_56,
	&l_ch_54,
	&l_ch_58,
	&l_ch_21,
	&l_ch_15,
	&l_ch_59,
	&l_ch_64,
	&l_ch_28,
	&l_ch_18,
	&l_ch_29,
	&l_ch_6,
	&l_ch_7,
	&l_ch_69,
	&l_ch_52,
 	&l_ch_8,
	&l_ch_61,
	&l_ch_37,
	&l_ch_30,
	&l_ch_26,
	&l_ch_25,
 	&l_ch_3,
	&l_ch_23,
	&l_ch_31,
	&l_ch_13,
	&l_ch_2,
};

extern BYTE RF_Mode;

BYTE Current_Channel = 0;
extern BOOL FHSS_Enable_902;
extern BOOL FHSS_Enable_863;
extern BOOL FHSS_Master_Enabled;
extern BOOL FHSS_Slave_Enabled;
extern BOOL FHSS_Sync_Detect;
extern BOOL IRQ1_Received;
extern BOOL hasPacket;
extern BYTE RxPacket[PACKET_LEN];
extern BYTE TxPacket[PACKET_LEN];
extern BOOL FHSS_Hop;
extern BYTE RVALUE;
extern BYTE PVALUE;
extern BYTE SVALUE;
extern BYTE FREQ_BAND;
/*********************************************************************
 * Function:    	void FHSS_Init(void)    
 *
 * PreCondition:    None
 *	
 * Input:           None
 *
 * Output:          Initializes, FHSS timer and programs the FHSS hop set sequence
 *                  
 *
 * Side Effects:    None
 *
 * Overview:        Initializes FHSS
 *                  
 *
 * Note:            
 ********************************************************************/
void FHSS_Init(void)
{
	RVALUE = RegisterRead(REG_R1);
	PVALUE = RegisterRead(REG_P1);
	SVALUE = RegisterRead(REG_S1);
	FHSS_Timer_Init(0x186A);
	Current_Channel = 0;
	PHY_IRQ1_En = 0;
	#if defined(__PIC24F__)
	PHY_IRQ0_En = 0;
	#endif									//Disable the interrupts
	//Program the start frequency and wait for the PLL lock -
	if(FHSS_Enable_902)
		{
		freq_t *freq;
		BYTE input;
		freq = ((freq_t*) freqs_P[Current_Channel]);
		//PrintChar(freq->R); 
		input = RegisterRead(REG_MCPARAM0);
		RegisterSet(REG_MCPARAM0, ((input & 0xE7) | (freq->MCParam_Band<<3)));
		//Program R, P,S registers
		RegisterSet(REG_R1, freq->R);
		RegisterSet(REG_P1, freq->P);
		RegisterSet(REG_S1, freq->S);
		
		input = RegisterRead(REG_MCPARAM0);
		RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
		RF_Mode = RF_SYNTHESIZER;
	
		/* clear PLL_LOCK flag so we can see it restore on the new frequency */
		input = RegisterRead(REG_IRQPARAM1);
		RegisterSet(REG_IRQPARAM1, (input | 0x02));
		Current_Channel++;
		}
	else
		{
		freq_t *freq;
		BYTE input;
		freq = ((freq_t*) l_freqs_P[Current_Channel]);
		//PrintChar(freq->R); 
		input = RegisterRead(REG_MCPARAM0);
		RegisterSet(REG_MCPARAM0, ((input & 0xE7) | (freq->MCParam_Band<<3)));
		//Program R, P,S registers
		RegisterSet(REG_R1, freq->R);
		RegisterSet(REG_P1, freq->P);
		RegisterSet(REG_S1, freq->S);
		
		input = RegisterRead(REG_MCPARAM0);
		RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
		RF_Mode = RF_SYNTHESIZER;
	
		/* clear PLL_LOCK flag so we can see it restore on the new frequency */
		input = RegisterRead(REG_IRQPARAM1);
		RegisterSet(REG_IRQPARAM1, (input | 0x02));
		Current_Channel++;
		}

	SetRFMode(RF_STANDBY);
	PHY_IRQ1_En = 1;
	#if defined(__PIC24F__)
	PHY_IRQ0_En = 1;
	#endif

}
/*********************************************************************
 * Function:        void FHSS_Exit(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          Resets FHSS Parameters to default values
 *                  
 *
 * Side Effects:    None
 *
 * Overview:        Resets FHSS Parameters to default values
 *                  
 *
 * Note:            
 ********************************************************************/
void FHSS_Exit(void)
{
BYTE input;
FHSS_Timer_Stop();
FHSS_Enable_902 = FALSE;
FHSS_Enable_863 = FALSE;
//Reset to Initial Center Frequency 
input = RegisterRead(REG_MCPARAM0);
RegisterSet(REG_MCPARAM0, ((input & 0xE7) | FREQ_BAND));
//Program R, P,S registers
RegisterSet(REG_R1, RVALUE);
RegisterSet(REG_P1, PVALUE);
RegisterSet(REG_S1, SVALUE);

input = RegisterRead(REG_MCPARAM0);
RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
RF_Mode = RF_SYNTHESIZER;

/* clear PLL_LOCK flag so we can see it restore on the new frequency */
input = RegisterRead(REG_IRQPARAM1);
RegisterSet(REG_IRQPARAM1, (input | 0x02));
SetRFMode(RF_STANDBY);
}

/*********************************************************************
 * Function:        void FHSS_Timer_Init(WORD tvalue)
 *
 * PreCondition:    None
 *
 * Input:           Timer value - Prescalar 256, Input clk = TOSC/2 = 4MHz
 *
 * Output:          Initializes the periodic timer with tvalue
 *                  
 *
 * Side Effects:    None
 *
 * Overview:        Programs Timer for FHSS - For using as 400ms accuracy timer
 *                  
 *
 * Note:            
 ********************************************************************/
void FHSS_Timer_Init(WORD tvalue)
{
#if defined(__PIC24F__)
	T2CON = 0x0030;	
	PR2 = tvalue;					//For 400ms
	T2CON = 0x8030;
	IEC0bits.T2IE = 1;				//Enable Timer 2 interrupt
	IFS0bits.T2IF = 0;				//Reset the timer interrupt;

#else		//for PIC18's

	

#endif
}

/*********************************************************************
 * Function:        void FHSS_Timer_Stop(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          Stops FHSS Timer
 *                  
 *
 * Side Effects:    None
 *
 * Overview:        Stops FHSS Timer
 *                  
 *
 * Note:            
 ********************************************************************/
void FHSS_Timer_Stop(void)
{
#if defined(__PIC24F__)
	T2CON = 0x0030;
	IEC0bits.T2IE = 0;				//Disable Timer 2 interrupt
	IFS0bits.T2IF = 0;				//Reset the timer interrupt;

#else		//for PIC18's

#endif
}

/*********************************************************************
 * Function:        void FHSS_Sync_Timer_Init(WORD tvalue)
 *
 * PreCondition:    None
 *
 * Input:           Periodic timer value for T3 (PIC24F), with prescalar
 *					setting 256 and TCY = FOSC/2 = 4MHz
 *
 * Output:          Initializes Sync Timer
 *                  
 *
 * Side Effects:    None
 *
 * Overview:        Timer used by Master for Synchronization - Generally
 *                  used to support 8ms accuracy
 *
 * Note:            
 ********************************************************************/
void FHSS_Sync_Timer_Init(WORD tvalue)
{
//Initialize the timer for 8 ms
#if defined(__PIC24F__)
	T3CON = 0x0030;
	PR3 = tvalue;
	T3CON = 0x8030;
	
	IEC0bits.T3IE = 0;
	IFS0bits.T3IF = 0;

#else	//for PIC18s

#endif
}

/*********************************************************************
 * Function:     	void FHSS_Sync_Timer_Stop(void)   
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          Stops T3(PIC24F) timer
 *                  
 *
 * Side Effects:    None
 *
 * Overview:        Stops FHSS Sync Timer
 *                  
 *
 * Note:            
 ********************************************************************/
void FHSS_Sync_Timer_Stop(void)
{

#if defined(__PIC24F__)

	T3CON = 0x0030;
	IEC0bits.T3IE = 0;
	IFS0bits.T3IF = 0;

#else	//for PIC18s

#endif
}

/*********************************************************************
 * Function:        BOOL FHSS_Sync_Timer_Expired(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          FHSS Sync Timer Status - Returns TRUE if timer expires
 *                  else FALSE
 *
 * Side Effects:    None
 *
 * Overview:        Returns FHSS Sync Timer Status
 *                  
 *
 * Note:            
 ********************************************************************/
BOOL FHSS_Sync_Timer_Expired(void)
{
#if defined(__PIC24F__)

if(IFS0bits.T3IF == 1)
	{
		IFS0bits.T3IF = 0;
		return TRUE;
	}	
else 
	return FALSE;
#else

#endif

}

/*********************************************************************
 * Function:        void FHSS_Sync_Start_Slave(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:         	Slave device waits until it receives the Sync message 
 *                  from the Master. Based on Sync Message, the slave jumps
 *					to the meeting channel
 * Side Effects:    None
 *
 * Overview:        Establishes synchronization with Master
 *                  
 *
 * Note:            
 ********************************************************************/
void FHSS_Sync_Start_Slave(void)
{
	BOOL Sync = FALSE;
	BYTE channel_info;
	FHSS_Timer_Stop();					//This enables Slave for Slow Hopping
	while(!Sync)
	{
		if(IRQ1_Received) ReceiveFrame();
		if(hasPacket)	
			{
				hasPacket = FALSE;
				if(RxPacket[0] == 0xFE)
					{
						if(RxPacket[1] == SYNC_COMMAND)
							{
		//						FHSS_Timer_Stop();
								//c("Sync Command Received\r\n");
								channel_info = RxPacket[2];
								Sync = TRUE;
							
							}
					}
					
			}
		if(ConsoleIsGetReady()) break;
	};		//End of While
	//Program with the channel info and wait for the dialog command
	
	{
		Current_Channel = channel_info;
		
		//Program with Channel value and wait for dialog phase
		{
		if(FHSS_Enable_902)
			{
			
															//Number of channels = 50
					freq_t *freq;
					BYTE input;
					freq = ((freq_t*) freqs_P[Current_Channel]);
					#if defined(VERBOSE)
					c("Frequency settings updated to - R = ");
					PrintChar(freq->R);
					c(", P = ");
					PrintChar(freq->P);
					c(", S = ");
					PrintChar(freq->S);
					c(", Band = ");
					PrintChar(freq->MCParam_Band);
					c("\r\n");
					#endif
					
					input = RegisterRead(REG_MCPARAM0);
					RegisterSet(REG_MCPARAM0, ((input & 0xE7) | (freq->MCParam_Band<<3)));
					//Program R, P,S registers
					RegisterSet(REG_R1, freq->R);
					RegisterSet(REG_P1, freq->P);
					RegisterSet(REG_S1, freq->S);
					
					input = RegisterRead(REG_MCPARAM0);
					RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
					RF_Mode = RF_SYNTHESIZER;
				
					/* clear PLL_LOCK flag so we can see it restore on the new frequency */
					input = RegisterRead(REG_IRQPARAM1);
					RegisterSet(REG_IRQPARAM1, (input | 0x02));
					SetRFMode(RF_RECEIVER);
					Current_Channel++;
					if(Current_Channel == 50) Current_Channel = 0;		
			}

			else
			{
				
				freq_t *freq;
				BYTE input;
				freq = ((freq_t*) l_freqs_P[Current_Channel]);
				#if defined(VERBOSE)
				c("Frequency settings updated to - R = ");
				PrintChar(freq->R);
				c(", P = ");
				PrintChar(freq->P);
				c(", S = ");
				PrintChar(freq->S);
				c(", Band = ");
				PrintChar(freq->MCParam_Band);
				c("\r\n");
				#endif
				
				input = RegisterRead(REG_MCPARAM0);
				RegisterSet(REG_MCPARAM0, ((input & 0xE7) | (freq->MCParam_Band<<3)));
				//Program R, P,S registers
				RegisterSet(REG_R1, freq->R);
				RegisterSet(REG_P1, freq->P);
				RegisterSet(REG_S1, freq->S);
				
				input = RegisterRead(REG_MCPARAM0);
				RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
				RF_Mode = RF_SYNTHESIZER;
			
				/* clear PLL_LOCK flag so we can see it restore on the new frequency */
				input = RegisterRead(REG_IRQPARAM1);
				RegisterSet(REG_IRQPARAM1, (input | 0x02));
				SetRFMode(RF_RECEIVER);
				Current_Channel++;
				if(Current_Channel == 70) Current_Channel = 0;
														//Number of channels = 69

			}
			
		}
		
	}
		
}

/*********************************************************************
 * Function:        void FHSS_Sync_Start_Master(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          Performs Synchronization with the Slaves
 *                  
 *
 * Side Effects:    None
 *
 * Overview:        Sends out Synchronization Message on all the 50 or
 *                  70 channels with 8ms accuracy
 *
 * Note:            
 ********************************************************************/
void FHSS_Sync_Start_Master(void)
{
	BOOL Sync = FALSE;
	BYTE Start_Channel_Info = Current_Channel;
	FHSS_Timer_Stop();
	FHSS_Sync_Timer_Init(0x007D);
								//Start 8 ms timer
	while(!Sync)
	{
		if(ConsoleIsGetReady()) break;
		
		//Transmit Sync packet with Channel info -
		{	
			TxPacket[0] = 0xFE;	//FHSS Mode
			TxPacket[1] = SYNC_COMMAND;
			TxPacket[2] = Start_Channel_Info;
			TxPacket[3] = Current_Channel;
			Send_Packet(4);
		}
		while(!FHSS_Sync_Timer_Expired()){};
		//Change Channel
		{
			Current_Channel++;
			//Start Synchronization procedure
			if(FHSS_Enable_902)
			{
					if(Current_Channel == 50) Current_Channel = 0;
															//Number of channels = 50
					
					{
					freq_t *freq;
					BYTE input;
					freq = ((freq_t*) freqs_P[Current_Channel]);
					#if defined(VERBOSE)
					c("Frequency settings updated to - R = ");
					PrintChar(freq->R);
					c(", P = ");
					PrintChar(freq->P);
					c(", S = ");
					PrintChar(freq->S);
					c(", Band = ");
					PrintChar(freq->MCParam_Band);
					c("\r\n");
					#endif
					
					input = RegisterRead(REG_MCPARAM0);
					RegisterSet(REG_MCPARAM0, ((input & 0xE7) | (freq->MCParam_Band<<3)));
					//Program R, P,S registers
					RegisterSet(REG_R1, freq->R);
					RegisterSet(REG_P1, freq->P);
					RegisterSet(REG_S1, freq->S);
					
					input = RegisterRead(REG_MCPARAM0);
					RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
					RF_Mode = RF_SYNTHESIZER;
				
					/* clear PLL_LOCK flag so we can see it restore on the new frequency */
					input = RegisterRead(REG_IRQPARAM1);
					RegisterSet(REG_IRQPARAM1, (input | 0x02));
					SetRFMode(RF_STANDBY);
					}
					
			}

			else
			{
				if(Current_Channel == 70) Current_Channel = 0;
					
										//Number of channels = 69
				{
				freq_t *freq;
				BYTE input;
				freq = ((freq_t*) l_freqs_P[Current_Channel]);
				#if defined(VERBOSE)
				c("Frequency settings updated to - R = ");
				PrintChar(freq->R);
				c(", P = ");
				PrintChar(freq->P);
				c(", S = ");
				PrintChar(freq->S);
				c(", Band = ");
				PrintChar(freq->MCParam_Band);
				c("\r\n");
				#endif
				
				input = RegisterRead(REG_MCPARAM0);
				RegisterSet(REG_MCPARAM0, ((input & 0xE7) | (freq->MCParam_Band<<3)));
				//Program R, P,S registers
				RegisterSet(REG_R1, freq->R);
				RegisterSet(REG_P1, freq->P);
				RegisterSet(REG_S1, freq->S);
				
				input = RegisterRead(REG_MCPARAM0);
				RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
				RF_Mode = RF_SYNTHESIZER;
			
				/* clear PLL_LOCK flag so we can see it restore on the new frequency */
				input = RegisterRead(REG_IRQPARAM1);
				RegisterSet(REG_IRQPARAM1, (input | 0x02));
				SetRFMode(RF_STANDBY);
				}
			}
		}	//End of Change Channel
		if(Current_Channel == Start_Channel_Info)
			{
			Sync = TRUE;	
							//Sync Phase complete
							//Transmit Dialog frame and get response to the dialog
			}
			

		};			// End of While
		FHSS_Sync_Timer_Stop();
}


/*********************************************************************
 * Function:        void FHSS_FreqHop(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          Programs the current center frequency to the Hop
 *                  channel specified by "Current_Channel"
 *
 * Side Effects:    None
 *
 * Overview:        Hops to "Current_Channel"
 *                  
 *
 * Note:            
 ********************************************************************/
void FHSS_FreqHop(void)
{
if(FHSS_Enable_902)
		//Program the start frequency and wait for the PLL lock -
		{
		freq_t *freq;
		BYTE input;
		freq = ((freq_t*) freqs_P[Current_Channel]);
		#if defined(VERBOSE)
		c("Frequency settings updated to - R = ");
		PrintChar(freq->R);
		c(", P = ");
		PrintChar(freq->P);
		c(", S = ");
		PrintChar(freq->S);
		c(", Band = ");
		PrintChar(freq->MCParam_Band);
		c("\r\n");
		#endif
		
		//PrintChar(Current_Channel);
		
		input = RegisterRead(REG_MCPARAM0);
		RegisterSet(REG_MCPARAM0, ((input & 0xE7) | (freq->MCParam_Band<<3)));
		//Program R, P,S registers
		RegisterSet(REG_R1, freq->R);
		RegisterSet(REG_P1, freq->P);
		RegisterSet(REG_S1, freq->S);
		
		input = RegisterRead(REG_MCPARAM0);
		RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
		RF_Mode = RF_SYNTHESIZER;
	
		/* clear PLL_LOCK flag so we can see it restore on the new frequency */
		input = RegisterRead(REG_IRQPARAM1);
		RegisterSet(REG_IRQPARAM1, (input | 0x02));
		Current_Channel++;
		if(Current_Channel == 50) Current_Channel = 0;
		}
		
		
	else
		{
		freq_t *freq;
		BYTE input;
		freq = ((freq_t*) l_freqs_P[Current_Channel]);
		#if defined(VERBOSE)
		c("Frequency settings updated to - R = ");
		PrintChar(freq->R);
		c(", P = ");
		PrintChar(freq->P);
		c(", S = ");
		PrintChar(freq->S);
		c(", Band = ");
		PrintChar(freq->MCParam_Band);
		c("\r\n");
		#endif
		
		input = RegisterRead(REG_MCPARAM0);
		RegisterSet(REG_MCPARAM0, ((input & 0xE7) | (freq->MCParam_Band<<3)));
		//Program R, P,S registers
		RegisterSet(REG_R1, freq->R);
		RegisterSet(REG_P1, freq->P);
		RegisterSet(REG_S1, freq->S);
		
		input = RegisterRead(REG_MCPARAM0);
		RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
		RF_Mode = RF_SYNTHESIZER;
	
		/* clear PLL_LOCK flag so we can see it restore on the new frequency */
		input = RegisterRead(REG_IRQPARAM1);
		RegisterSet(REG_IRQPARAM1, (input | 0x02));
		Current_Channel++;
		if(Current_Channel == 70) Current_Channel = 0;
		}
		SetRFMode(RF_RECEIVER);
	
}

#if defined(__PIC24F__)
void  _ISRFAST __attribute__((interrupt, auto_psv)) _T2Interrupt(void)
{
	if(IFS0bits.T2IF && IEC0bits.T2IE)
	{

		FHSS_Hop = TRUE;
		
		if(FHSS_Master_Enabled | FHSS_Slave_Enabled)
			{
				FHSS_Sync_Detect = TRUE;
			}

	}
		
	IFS0bits.T2IF = 0;
}

#endif


//End of the file
