
#include "MRF89XA.h"
#include "GenericTypeDefs.h"
#include "compiler.h"
#include "RadioDriverDefs.h"
#include "spi.h"
#include "Console.h"

//First time configuration settings for MRF89XA
ROM char InitConfigRegs[] = {
		/* 0 */				CHIPMODE_STBYMODE | FREQBAND_915 | VCO_TRIM_11, 
		/* 1 */				MODSEL_FSK | DATAMODE_PACKET | IFGAIN_0,
		/* 2 */				FREGDEV_80,
		/* 3 */				BITRATE_25,
		/* 4 */				OOKFLOORTHRESH_VALUE,
		/* 5 */				FIFOSIZE_64 | FIFO_THRSHOLD_1,
		/* 6 */				0,
		/* 7 */				0,
		/* 8 */				0,
		/* 9 */				0,
		/* 10 */			0,
		/* 11 */			0,
		/* 12 */			DEF_PARAMP | PA_RAMP_23,
		/* 13 */			IRQ0_RX_STDBY_SYNCADRS | IRQ1_RX_STDBY_CRCOK | IRQ1_TX_TXDONE,                     
		/* 14 */ 			DEF_IRQPARAM1 | IRQ0_TX_START_FIFOTHRESH | IRQ1_PLL_LOCK_PIN_ON,
		/* 15 */ 			RSSIIRQTHRESH_VALUE,
		/* 16 */ 			PASSIVEFILT_378 | RXFC_FOPLUS100,
		/* 17 */			DEF_RXPARAM1 | FO_100,
		/* 18 */			DEF_RXPARAM2 | POLYPFILT_OFF | SYNC_SIZE_32 | SYNC_ON | SYNC_ERRORS_0,
		/* 19 */			DEF_RXPARAM3,
		/* 20 */			0,
		/* 21 */			OOK_THRESH_DECSTEP_000 | OOK_THRESH_DECPERIOD_000 | OOK_THRESH_AVERAGING_00,
		/* 22 */ 			0x69, // 1st byte of Sync word,
		/* 23 */ 			0x81, // 2nd byte of Sync word,
		/* 24 */ 			0x7E, // 3rd byte of Sync word,
		/* 25 */ 			0x96, // 4th byte of Sync word,
		/* 26 */ 			FC_400 | TXPOWER_13,
		/* 27 */ 			CLKOUT_ON | CLKOUT_12800,
		/* 28 */ 			MANCHESTER_OFF | 64,
		/* 29 */ 			NODEADRS_VALUE,
		/* 30 */ 			PKT_FORMAT_VARIABLE | PREAMBLE_SIZE_4 | WHITENING_OFF | CRC_ON | ADRSFILT_NONE,
 		/* 31 */ 			FIFO_AUTOCLR_ON | FIFO_STBY_ACCESS_WRITE 
							};	
//declare external variables
extern BOOL IRQ1_Received;
#if defined(__PIC24F__)
extern BOOL IRQ0_Received;
#endif
extern BOOL LED_1_SET;
extern BOOL LED_2_SET;
extern BYTE RxPacketLen;
extern BOOL hasPacket;
extern BYTE RF_Mode;
extern BYTE TxPacket[PACKET_LEN];
extern BYTE RxPacket[PACKET_LEN];
extern BOOL Enable_DutyCycle;
extern WORD Duty_Cycle;



void RegisterSet(BYTE address, BYTE value)
{
	volatile BYTE tmp0RFIE = PHY_IRQ1_En;
	#if defined(__PIC24F__)
	volatile BYTE tmp1RFIE = PHY_IRQ0_En;
	#endif
	PHY_IRQ1_En = 0;
	#if defined(__PIC24F__)
	PHY_IRQ0_En = 0;
	IEC0bits.T2IE = 0;
	#endif
    Config_nCS = 0;
	address = (address<<1);
    SPIPut(address);
    SPIPut(value);
    Config_nCS = 1;
	PHY_IRQ1_En = tmp0RFIE;
	#if defined(__PIC24F__)
	PHY_IRQ0_En = tmp1RFIE;
	IEC0bits.T2IE = 1;
	#endif
}




BYTE RegisterRead(BYTE address)
{
	volatile BYTE tmp0RFIE = PHY_IRQ1_En;
	#if defined(__PIC24F__)
	volatile BYTE tmp1RFIE = PHY_IRQ0_En;
	IEC0bits.T2IE = 0;
	#endif
	BYTE value;
    Config_nCS = 0;
	address = ((address<<1)|0x40);
    SPIPut(address);
	value = SPIGet();
    Config_nCS = 1;
	PHY_IRQ1_En = tmp0RFIE;
	#if defined(__PIC24F__)
	PHY_IRQ0_En = tmp1RFIE;
	IEC0bits.T2IE = 1;
	#endif
	return value;
}




void Send_Packet(BYTE TxPacketLen)
{
	WORD i;
	BYTE j;
	SetRFMode(RF_STANDBY);
	#if defined(__18F87J11)
	
	#else
		IEC0bits.T2IE = 0;
	#endif
	RegisterSet(REG_PKTPARAM3, ((InitConfigRegs[REG_PKTPARAM3] & 0xBF)| FIFO_STBY_ACCESS_WRITE));
	RegisterSet(REG_IRQPARAM0, (InitConfigRegs[REG_IRQPARAM0] | IRQ1_FIFO_OVERRUN_CLEAR ));
	RegisterSet(REG_IRQPARAM1, ((InitConfigRegs[REG_IRQPARAM1]) | 0x02));
	WriteFIFO(TxPacketLen+1);
	WriteFIFO(0x00);		//Node_adrs
	for(i=0; i< TxPacketLen; i++)
	{
		WriteFIFO(TxPacket[i]);
	}
	if(Enable_DutyCycle)
		{

			//Initialize timer T3 with TMR3 = 0
			T3CON = 0x8030;
			IEC0bits.T3IE = 0;
			IFS0bits.T3IF = 0;
			PR3 = 0xFFFF;
			TMR3 = 0x0000;
	
		}
	SetRFMode(RF_TRANSMITTER);
	while(!IRQ1_Received);	//Wait until TX Done interrupt and restore the RF state to standby mode
	SetRFMode(RF_STANDBY);
	if(Enable_DutyCycle)
		{
		WORD i;

			WORD temp_tmr3 = TMR3;
			T3CONbits.TON = 0;
			IFS0bits.T3IF = 0;
			PR3 = (temp_tmr3+1);
			T3CONbits.TON = 1;
			for(i=0;i<Duty_Cycle;i++)
				{
				while(IFS0bits.T3IF == 0);
				IFS0bits.T3IF = 0;
				TMR3 = 0;
				}
			T3CONbits.TON = 0;

		}
	IRQ1_Received = FALSE;

		IEC0bits.T2IE = 1;

	if(LED_1_SET)
		{
		LED_1 = 0;
		LED_1_SET = FALSE;
		}
	else
		{
		LED_1 = 1;
		LED_1_SET = TRUE;
		}

	//Reset FIFO
	j = RegisterRead(REG_IRQPARAM0);
	RegisterSet(REG_IRQPARAM0, (j | 0x01));
    
}




void WriteFIFO(BYTE Data)
{
	volatile BYTE tmp0RFIE = PHY_IRQ1_En;
	#if defined(__PIC24F__)
	volatile BYTE tmp1RFIE = PHY_IRQ0_En;
	#endif
	PHY_IRQ1_En = 0;
    Data_nCS = 0;
    SPIPut(Data);
    Data_nCS = 1;
	PHY_IRQ1_En = tmp0RFIE;
	#if defined(__PIC24F__)
	PHY_IRQ0_En = tmp1RFIE;
	#endif
}





void ReceiveFrame()
{
	BYTE data, node_adrs;
	BYTE i = 0;
	if(IRQ1_Received)
		{
		RxPacketLen = ReadFIFO();	
		IRQ0_Received = FALSE;
		node_adrs = ReadFIFO();
		RxPacketLen = (RxPacketLen-1);

		while(RxPacketLen--)
			{
			IRQ0_Received = FALSE;
			data = ReadFIFO();
			RxPacket[i] = data;
			i++;
			};
		RxPacketLen = i;
		}	
	IRQ1_Received = FALSE;
	if(LED_2_SET)
		{
		LED_2 = 0;
		LED_2_SET = FALSE;
		}
	else
		{
		LED_2 = 1;
		LED_2_SET = TRUE;
		}
	hasPacket = TRUE;
	//Reset FIFO
	i = RegisterRead(REG_IRQPARAM0);
	RegisterSet(REG_IRQPARAM0, (i | 0x01));
}





BYTE ReadFIFO(void)
{
	volatile BYTE tmp0RFIE = PHY_IRQ1_En;
	#if defined(__PIC24F__)
	volatile BYTE tmp1RFIE = PHY_IRQ0_En;
	#endif
	BYTE value;
    Data_nCS = 0;
	value = SPIGet();
    Data_nCS = 1;
	PHY_IRQ1_En = tmp0RFIE;
	#if defined(__PIC24F__)
	PHY_IRQ0_En = tmp1RFIE;
	#endif
	return value;
	
}







void SetRFMode(BYTE mode)
{
	BYTE	mcparam0_read;
	mcparam0_read = RegisterRead(REG_MCPARAM0);
	switch (mode) {
		case RF_TRANSMITTER:
			RegisterSet(REG_MCPARAM0, (mcparam0_read & 0x1F) | RF_TRANSMITTER);
			RF_Mode = RF_TRANSMITTER;				//RF in TX mode
			break;
		case RF_RECEIVER:
			RegisterSet(REG_MCPARAM0, (mcparam0_read & 0x1F) | RF_RECEIVER);
			RF_Mode = RF_RECEIVER;					//RF in RX mode
			break;
		case RF_SYNTHESIZER:
			RegisterSet(REG_MCPARAM0, (mcparam0_read & 0x1F) | RF_SYNTHESIZER);
			RF_Mode = RF_SYNTHESIZER;				//RF in Synthesizer mode
			break;
		case RF_STANDBY:
			RegisterSet(REG_MCPARAM0, (mcparam0_read & 0x1F) | RF_STANDBY);
			RF_Mode = RF_STANDBY;					//RF in standby mode
			break;
		case RF_SLEEP:
			RegisterSet(REG_MCPARAM0, (mcparam0_read & 0x1F) | RF_SLEEP);
			RF_Mode = RF_SLEEP;						//RF in sleep mode
			break;
	} /* end switch (mode) */

}
