
#include "RadioDriverDefs.h"
#include "FHSS.h"
#include "MRF89XA.h"
#include "spi.h"
#include "Console.h"
#include "compiler.h"
#include <stdio.h>



#include <string.h>
#include <float.h>


// CONFIG4
#pragma config DSWDTPS = DSWDTPSF    //DSWDT Postscale Select->1:2,147,483,648 (25.7 days)
#pragma config DSWDTOSC = LPRC    //Deep Sleep Watchdog Timer Oscillator Select->DSWDT uses Low Power RC Oscillator (LPRC)
#pragma config RTCOSC = SOSC    //RTCC Reference Oscillator  Select->RTCC uses Secondary Oscillator (SOSC)
#pragma config DSBOREN = ON    //Deep Sleep BOR Enable bit->BOR enabled in Deep Sleep
#pragma config DSWDTEN = ON    //Deep Sleep Watchdog Timer->DSWDT enabled

// CONFIG3
#pragma config WPFP = WPFP63    //Write Protection Flash Page Segment Boundary->Highest Page (same as page 42)
#pragma config SOSCSEL = IO    //Secondary Oscillator Pin Mode Select->SOSC pins have digital I/O functions (RA4, RB4)
#pragma config WUTSEL = LEG    //Voltage Regulator Wake-up Time Select->Default regulator start-up time used
#pragma config WPDIS = WPDIS    //Segment Write Protection Disable->Segmented code protection disabled
#pragma config WPCFG = WPCFGDIS    //Write Protect Configuration Page Select->Last page and Flash Configuration words are unprotected
#pragma config WPEND = WPENDMEM    //Segment Write Protection End Page Select->Write Protect from WPFP to the last page of memory

// CONFIG2
#pragma config POSCMOD = NONE    //Primary Oscillator Select->Primary Oscillator disabled
#pragma config I2C1SEL = PRI    //I2C1 Pin Select bit->Use default SCL1/SDA1 pins for I2C1 
#pragma config IOL1WAY = ON    //IOLOCK One-Way Set Enable->Once set, the IOLOCK bit cannot be cleared
#pragma config OSCIOFNC = ON    //OSCO Pin Configuration->OSCO pin functions as port I/O (RA3)
#pragma config FCKSM = CSDCMD    //Clock Switching and Fail-Safe Clock Monitor->Sw Disabled, Mon Disabled
#pragma config FNOSC = FRCDIV    //Initial Oscillator Select->Fast RC Oscillator with Postscaler (FRCDIV)
#pragma config PLL96MHZ = ON    //96MHz PLL Startup Select->96 MHz PLL Startup is enabled automatically on start-up
#pragma config PLLDIV = DIV12    //USB 96 MHz PLL Prescaler Select->Oscillator input divided by 12 (48 MHz input)
#pragma config IESO = OFF    //Internal External Switchover->IESO mode (Two-Speed Start-up) disabled

// CONFIG1
#pragma config WDTPS = PS32768    //Watchdog Timer Postscaler->1:32768
#pragma config FWPSA = PR128    //WDT Prescaler->Prescaler ratio of 1:128
#pragma config WINDIS = OFF    //Windowed WDT->Standard Watchdog Timer enabled,(Windowed-mode is disabled)
#pragma config FWDTEN = OFF    //Watchdog Timer->Watchdog Timer is disabled
#pragma config ICS = PGx3    //Emulator Pin Placement Select bits->Emulator functions are shared with PGEC3/PGED3
#pragma config GWRP = OFF    //General Segment Write Protect->Writes to program memory are allowed
#pragma config GCP = OFF    //General Segment Code Protect->Code protection is disabled
#pragma config JTAGEN = OFF    //JTAG Port Enable->JTAG port is disabled



//Defines for RadioDriver.c file
#define PR_RX_MODE	0x00
#define PR_TX_MODE	0x01
#define PR_TX_RX_MODE	0x02

//variables
//initialized variable
BYTE RF_Mode = RF_STANDBY;
ROM char PredefinedPacket[] = {0x01,0x08,0xC4,0xFF,0xFF,0xFF,0xFF,0x07,0x01,0x00,0x01,0x00,0x04,0x00,0x00,0x00};
ROM char SynchronPacket[] = {0xFF,0xFF,0x00,0x00,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0xFF};
BYTE RandomBuffer[100];
BYTE PacketDelay = 1;
float Fxtal = 12800;			//crystal frequency 12.8 MHz
WORD RxCount = 0;				//Used for counting Rx packets received
BYTE RxPrintCount;				//Used for printing header for the displayed data
BYTE TX_FREQ_BW = FC_125;
BYTE RSSIRegVal = 0;			//For reading RSSI

//variables for Ping-Pong mode
WORD PingPong_Package = 100;	//Ping Pong Package size
WORD PingPong_Count = 0;		//Ping Pong package current count
BOOL PingPongSend = FALSE;
BOOL PingPongReceive = FALSE;
BOOL PingPongTest = FALSE;

//variables for PER test mode
BYTE PER_Packet_Size = 16;		//PER test packet size (choose from options - 16, 32, 64)
WORD PER_Count = 0;				//PER received packet counter
BOOL Synchron = FALSE;			//remove me
BOOL PERStatus = FALSE;
BOOL PERSend = FALSE;
BOOL PERReceive = FALSE;
BOOL PERTest = FALSE;
WORD PERMaxCount = 100;			//PER package count(choose from 10 or 100 or 1000) using this variable. Not an option from the program

//FHSS mode
BOOL FHSS_Enable_902 = FALSE;
BOOL FHSS_Enable_863 = FALSE;
BOOL FHSS_Master_Enabled = FALSE;
BOOL FHSS_Slave_Enabled = FALSE;
BOOL Channel_spacing_100 = FALSE;
BOOL Channel_spacing_50 = FALSE;
BOOL Channel_spacing_25 = FALSE;
BOOL FHSS_Sync_Detect = FALSE;
BOOL FHSS_Hop = FALSE;
extern BYTE Current_Channel;

//Duty Cycle
BOOL Enable_DutyCycle = FALSE;
WORD Duty_Cycle = 0x0000;

//LED status
BOOL LED_1_SET = FALSE;
BOOL LED_2_SET = FALSE;

//Interrupt flags
BYTE RX_STBY_IRQ1_SRC = IRQ1_RX_STDBY_CRCOK;
BYTE RX_STBY_IRQ0_SRC = IRQ0_RX_STDBY_FIFOEMPTY;
BYTE TX_IRQ1_SRC = IRQ1_TX_TXDONE;
BYTE TX_START_IRQ0_SRC = IRQ0_TX_START_FIFOTHRESH;

//receive flags
BOOL hasPacket = FALSE;			//indicates that data packet is available in RX buffer


//uninitialized variable - MRF89XA variables
WORD Rate_R;
WORD Rate_C;		//Data Rate
BYTE FREQ_BW;		//Frequenncy bandwidth - Receiver
BYTE FREQ_BAND;		//Frequency band - (902-915 / 915-928 / 950-960 or 863-870)
BYTE RVALUE;		//Register R value
BYTE PVALUE;		//Register P value
BYTE SVALUE;		//Register S value
BYTE TX_FSK;		//Frequency deviation register setting
BYTE IF_GAIN;		//IF filter gain register setting
BYTE TX_PWR;		//TX power register setting
BYTE PFILTER_SETTING;	//SIDEBAND FILTER SETTING
BOOL DATA_Whitening = FALSE;	//By default Data Whitening is disabled
BOOL Modulation_Type = TRUE;	//Implies FSK modulation ele OOK modulation
BOOL Data_out = 0;
BYTE Data_Mode = DATAMODE_PACKET;

//remove me ------
BYTE FREQ_BAND_RESET;
BYTE RVALUE_RESET;
BYTE PVALUE_RESET;
BYTE SVALUE_RESET;

//external variables
extern ROM char InitConfigRegs[];	//Initial Configuration setting values

//used as extern in other files
BOOL IRQ1_Received = FALSE;		//indicates whether IRQ0 has been received or not

BOOL IRQ0_Received = FALSE;		//indicates whether IRQ1 has been received or not

BYTE TxPacket[PACKET_LEN];		//TX buffer
BYTE RxPacket[PACKET_LEN];		//RX buffer
BYTE TxPacLen;					//Packet length for TX packet
BYTE RxPacketLen;				//Packet length for Received packet


//Function prototypes
void BoardInit(void);
void PrintHeader(ROM char*);
void PrintSubHeader(ROM char*);
void MRF89XAInit(void);
void PrintStatus(void);
void PrintMiniStatus(BYTE);
void ResetMRF89XA(void);
void Setup(void);
	






int main(void)

{   
BYTE input;
						//call all the initialization routines
BoardInit();			//initialize the board
ConsoleInit();			//initialize the console
MRF89XAInit();			//initialize MRF89XA
Setup();				//Configure the basic settings
						//Print the Main menu on the screen
MainMenu:
	PingPongSend = FALSE;
	PingPongReceive = FALSE;
	PingPongTest = FALSE;
	Synchron = FALSE;
	PERSend = FALSE;
	PERReceive = FALSE;
	LED_1_SET = FALSE;
	LED_2_SET = FALSE;
	LED_1 = 0;
	LED_2 = 0;
	PrintHeader((ROM char*) "Main Menu");
	c("	b.Transmit\r\n");
	c("	c.Receive\r\n");
	c(">>");
	
						//Idle loop
while(!ConsoleIsGetReady())
	{

	}
						//Read the input from the console

	input = ConsoleGet();
	ConsolePut(input);
	nl();
				
	switch(input)		//Main menu cases	
	{
        // TRASMIT
		case 'b':
		case 'B':	
TransmitMenu:		PrintSubHeader((ROM char*)"Transmit");
					c("	a.Transmit predefined packet continuously\r\n");

					c(">>");
					while(!ConsoleIsGetReady());
					input = ConsoleGet();
					ConsolePut(input);
					nl();
					switch(input)
					{
						case 'a':
						case 'A': 	c("Transmitting predefined packet at");
									PrintMiniStatus(PR_TX_MODE);
								  	c("Press (Ctrl+z) to exit\r\n");
									{
										BYTE TxPacket_Len;
										BYTE i;
										WORD j,k;
										for(i=0;i<sizeof(PredefinedPacket);i++)
										TxPacket[i] = PredefinedPacket[i];
										TxPacket_Len = sizeof(PredefinedPacket);							
								  	while(1)
									{
										if(ConsoleIsGetReady())
										{	
											input = ConsoleGet();
											ConsolePut(input);
											if(input == 26)
											goto MainMenu;
										}
										if(FHSS_Hop)
												{
													FHSS_FreqHop();
													FHSS_Hop = FALSE;
												}
										Send_Packet(TxPacket_Len);
										if(!Enable_DutyCycle)
										{
											k = PacketDelay;
											do
	                        				{
	                 			               for(j=0;j<2000;j++)
	               	                          {
	                				          }
	                        				}while(k--);
										}
									}
									}
									break;

						default:	c("Re-Program\r\n");
									goto TransmitMenu;
					}
					break;
                    
                    
                    
                // RECEIVE    
		case 'c':
		case 'C':
					PrintSubHeader((ROM char*)"Receive");
					c("	a.Verbose mode\r\n");
					c("	b.Summary mode\r\n");
					c("	c.Packet Count mode\r\n");
					c(">>");
					while(!ConsoleIsGetReady());
					input = ConsoleGet();
					ConsolePut(input);
					nl();
					switch(input)
					{
						case 'a':
						case 'A':	if(FHSS_Enable_902 | FHSS_Enable_863) 
										{
											FHSS_Exit();
											c("\r\nFHSS Mode is Disabled\r\n");
										}
									c("\r\nMRF89XA in Verbose Receive Mode at");
									PrintMiniStatus(PR_RX_MODE);
									c("Press Ctrl+z to exit\r\n");
									RxPrintCount = 20;
									hasPacket = FALSE;	//reset buffer
									RxCount = 0;
									SetRFMode(RF_RECEIVER);
			
									while(1)
									{
	

										if(ConsoleIsGetReady())
											{
											input = ConsoleGet();
											if(input == 26)
												goto MainMenu;
											}
										if(RxPrintCount == 20 )
										{
										c("Number | Length |        Packet Data         | RSSI (in dB)\r\n");
										nl();
										RxPrintCount = 0;
										}
										
										if(IRQ1_Received)
										{
											ReceiveFrame();
										}							 
										if( hasPacket )
							        	{
										BYTE i;
										RxCount++;
										PrintDigitW(RxCount);
										c("   |     ");
										PrintChar(RxPacketLen);
										c(" | ");	
							        	for(i = 0; i < RxPacketLen; i++)
							        	{
							        		PrintChar(RxPacket[i]);
											c(" ");
							            }
										c(" | ");
													
										PrintDigit(RSSIRegVal);
							            hasPacket = FALSE;
										RxPrintCount++;
										nl();
							            RxPacketLen = 0;
							        	}
									}	
									SetRFMode(RF_STANDBY);	
									break;
						case 'b':
						case 'B':	if(FHSS_Enable_902 | FHSS_Enable_863) 
										{
											FHSS_Exit();
											c("\r\nFHSS Mode is Disabled\r\n");
										}
									c("\r\n MRF89XA in Summary Receive Mode at");
									PrintMiniStatus(PR_RX_MODE);
									c("Press Ctrl+z to exit\r\n");
									{	
									BYTE HeaderCount = 0;
										//initialize timers
				
										T1CON = 0x8030;
										PR1 = 0x3D09;
										IEC0bits.T1IE = 0;
								
										hasPacket = FALSE;
										RxCount = 0;
										SetRFMode(RF_RECEIVER);
										while(1)
											{
												if(ConsoleIsGetReady())
													{
														input = ConsoleGet();
														ConsolePut(input);
														if(input == 26)
															{
												
																T1CON = 0x0030;
										
															goto MainMenu;
															}
														if(input == 24)
															{
																ResetMRF89XA();
																goto MainMenu;
															}
													}
												if(IRQ1_Received)
													ReceiveFrame();
												if(hasPacket)
													{
														RxCount++;
														hasPacket = FALSE;
													}
								
														if(IFS0bits.T1IF)	
											
															{
												
																	IFS0bits.T1IF = 0;
															
																if(HeaderCount == 0)
																	c("\r\nRX Packet Count\r\n");
																HeaderCount++;
																if(HeaderCount == 20)
																	HeaderCount = 0;
																PrintDigitW(RxCount);
																c("\r\n");
																RxCount = 0;																
																
															}
											}	
										}
									SetRFMode(RF_STANDBY);
									break;
						case 'c':
						case 'C':	if(FHSS_Enable_902 | FHSS_Enable_863) 
										{
											FHSS_Exit();
											c("\r\nFHSS Mode is Disabled\r\n");
										}
									c("\r\n MRF89XA in Packet Count Mode\r\n");
									PrintMiniStatus(PR_RX_MODE);
									c("Press <Ctrl+z> to exit\r\n");
									{
										WORD RxPacketCount = 0;
										SetRFMode(RF_RECEIVER);
										while(!ConsoleIsGetReady())
										{
											if(IRQ1_Received) ReceiveFrame();
											if(hasPacket)
											{
												hasPacket = FALSE;
												RxPacketCount++;
												c("\r\nRx Packet Count = ");
												PrintDigitW(RxPacketCount);
											}
											
										}
										c("\r\n Total Packet Count received = ");
										PrintDigitW(RxPacketCount);
										input = ConsoleGet();
										ConsolePut(input);
										if(input == 24) ResetMRF89XA();
									}
									SetRFMode(RF_STANDBY);
									break;

						HOTKEYS
						default: 	c("\r\nRe-Program\r\n");
									break;
					}	
					break;

		default: 	
					c("Re-Program\r\n");
					goto MainMenu;
		}
		goto MainMenu;	
}








void BoardInit(void)
{
    LATA = 0x0000;
    LATB = 0x0000;

    TRISA = 0b00111;
    TRISB = 0b0111000011100101;;

    CNPU1 = 0x0000;
    CNPU2 = 0x0000;

    ODCA = 0x0000;
    ODCB = 0x0000;

		Config_nCS_TRIS = 0;       // RB1 as Config_nCS
		Data_nCS_TRIS = 0;			// RB2 as Data_nCS
    	PHY_SCK_TRIS = 0;       // SCK 
    	PHY_SDI_TRIS = 0;       // SDI
    	PHY_SDO_TRIS = 1;       // SDO
		PHY_IRQ0_TRIS = 1;		//INT1 input
		PHY_IRQ1_TRIS = 1;		//INT2 input
		DATA_PIN_TRIS = 0;		//Output data pin
			RESET_TRIS = 1;

    AD1PCFG = 0b0001111111111111;
    
    __builtin_write_OSCCONL(OSCCON & 0xbf); // unlock PPS

    RPINR1bits.INT2R = 0x000E;    //RB14->EXT_INT:INT2
    RPINR19bits.U2RXR = 0x0002;    //RB2->UART2:U2RX
    RPOR0bits.RP1R = 0x0006;    //RB1->UART2:U2RTS
    RPINR0bits.INT1R = 0x000D;    //RB13->EXT_INT:INT1
    RPOR1bits.RP3R = 0x0005;    //RB3->UART2:U2TX
    RPOR4bits.RP8R = 0x0007;    //RB8->SPI1:SDO1
    RPOR2bits.RP4R = 0x0008;    //RB4->SPI1:SCK1OUT
    RPINR19bits.U2CTSR = 0x0000;    //RB0->UART2:U2CTS
    RPINR20bits.SDI1R = 0x0007;    //RB7->SPI1:SDI1
    
    __builtin_write_OSCCONL(OSCCON | 0x40); // lock PPS
    
        LED_1_TRIS = 0;
        LED_2_TRIS = 0;
            
     	INTCON2bits.INT1EP = 0;
		INTCON2bits.INT2EP = 0;
	    PHY_IRQ0 = 0;
    	PHY_IRQ0_En = 0; //disable interrupts
		PHY_IRQ1 = 0;
		PHY_IRQ1_En = 0; //disable interrupts
    
    	Config_nCS = 1;          //Config_nCS inactive
		Data_nCS = 1;			//Data_nCS inactive
		
        SPI1CON1 = 0b0000000100111110;
        SPI1STAT = 0x8000;
}









void MRF89XAInit(void)
{
	BYTE input,i=0;

	for (i = 0 ; i <= 31; i++)
	{
	RegisterSet(i, InitConfigRegs[i]);	
	}
	RF_Mode = RF_STANDBY;
	input = RegisterRead(REG_MCPARAM0);
	RegisterSet(REG_MCPARAM0, (input & 0x1F) | RF_SYNTHESIZER);        		
	RF_Mode = RF_SYNTHESIZER;

	/* clear PLL_LOCK flag so we can see it restore on the new frequency */\
	input = RegisterRead(REG_IRQPARAM1);
	RegisterSet(REG_IRQPARAM1, (input | 0x02));

	input = RegisterRead(REG_MCPARAM0);
	RegisterSet(REG_MCPARAM0, ((input & 0xE7) | FREQBAND_915));
	//Program R, P,S registers
	RegisterSet(REG_R1, 119);
	RegisterSet(REG_P1, 100);
	RegisterSet(REG_S1, 52);
	input = RegisterRead(REG_MCPARAM0);
	RegisterSet(REG_MCPARAM0, ((input & 0x1F) | RF_SYNTHESIZER));        		
	RF_Mode = RF_SYNTHESIZER;

	/* clear PLL_LOCK flag so we can see it restore on the new frequency */
	input = RegisterRead(REG_IRQPARAM1);
	RegisterSet(REG_IRQPARAM1, (input | 0x02));

	SetRFMode(RF_STANDBY);
	PHY_IRQ1_En = 1;

	PHY_IRQ0_En = 1;

}














void PrintHeader(ROM char *app)
{
 
}












void PrintSubHeader(ROM char *app)
{
 
}








void PrintStatus()
{

}



void PrintMiniStatus(BYTE mode)
{

}











void ResetMRF89XA(void)
{
	PacketDelay = 1;				//resets all the variables to reset values
	RxCount = 0;
	PingPong_Package = 100;
	MRF89XAInit();
	ConsolePutROMString ((ROM char *)"MRF89XA Device has been reset \r\n");
}






void Setup(void)
{
	BYTE input;
	SetRFMode(RF_STANDBY);
										//Program the chip to standby mode before changing from FSK to OOK or OOK to FSK
	PrintHeader((ROM char*)"Setup");
	c("The following three steps are one time configuration settings for the transceiver.If additional configuration settings are needed, please use \"Configure MRF89XA\" menu from Main Menu\r\n\r\n");
    
Setup_Phase0:
	c("Select type of Modulation\r\n\r\n");
	c(" 1. FSK\r\n");
	c(">>");
	while(!ConsoleIsGetReady()){};
	input = ConsoleGet();
	ConsolePut(input);
	switch(input)
	{
	case '1':		//FSK Modulation
				Modulation_Type = TRUE;
				break;

	default:	c("\r\nRe-Program\r\n");
					goto Setup_Phase0;
	}

			//Program FSK Modulation parameters
			input = RegisterRead(REG_MCPARAM1);
			input = ((input & 0x3F) | MODSEL_FSK);
			RegisterSet(REG_MCPARAM1, input);
		

Setup_Phase1:
        
	c("\r\n");
	c("Select Frequency of operation for the transceiver\r\n\r\n");
	c(" 4. Frequency Band = 863-870 MHz, Center Frequency = 868 MHz\r\n");
	c(">>");
	

	while(!ConsoleIsGetReady()){};
	input = ConsoleGet();
	ConsolePut(input);
	switch(input)
	{
		case '4':	FREQ_BAND = FREQ_BAND_RESET = FREQBAND_950;
					RVALUE = RVALUE_RESET = 125;
					PVALUE = PVALUE_RESET = 100;
					SVALUE = SVALUE_RESET = 20;
					//Center Frequency setting = 868 MHz
					break;
		default:	c("\r\nRe-Program\r\n");
					goto Setup_Phase1;
	}

	RegisterSet(REG_MCPARAM0, ((InitConfigRegs[REG_MCPARAM0]&0xE7)|FREQ_BAND));
	if(FREQ_BAND == FREQBAND_950)
	{
		BYTE readback = RegisterRead(REG_MCPARAM0);
		readback = (readback & 0xF8);
		RegisterSet(REG_MCPARAM0, readback);
	}
	RegisterSet(REG_R1, RVALUE);
	RegisterSet(REG_P1, PVALUE);
	RegisterSet(REG_S1, SVALUE);
	
    
    
Setup_Phase2:

	c("\r\n");
	c(" 4. DataRate = 20 kbps, BW = 75 KHz, Frequency Deviation = 40 KHz\r\n");
	c(">>");
	while(!ConsoleIsGetReady());
	input = ConsoleGet();
	ConsolePut(input);

			switch(input)
			{
				case '4': 	Rate_C = BITRATE_20; Rate_R = 20;
							FREQ_BW = RXFC_FOPLUS75;
							TX_FSK = FREGDEV_40;
							PFILTER_SETTING = PASSIVEFILT_234;
							break;
				default:	c("\r\nRe-Program\r\n");
							goto Setup_Phase2;
			}
			RegisterSet(REG_BITRATE, Rate_C);
			RegisterSet(REG_RXPARAM0, (FREQ_BW | PFILTER_SETTING));
			RegisterSet(REG_FREGDEV, TX_FSK);	
	
	//Perform frequency synthesization
	input = RegisterRead(REG_MCPARAM0);
	RegisterSet(REG_MCPARAM0, (input & 0x1F) | RF_SYNTHESIZER);        		
	RF_Mode = RF_SYNTHESIZER;

	//clear PLL_LOCK flag so we can see it restore on the new frequency 
	input = RegisterRead(REG_IRQPARAM1);
	RegisterSet(REG_IRQPARAM1, (input | 0x02));
	
	SetRFMode(RF_RECEIVER);
	//transceiver will be set to FSK or OOK mode
	//Include delay and put the chip back to standby mode
	{
	WORD i;
	for(i=0;i<5000;i++)
	{
		Nop();
	}
	}
	SetRFMode(RF_STANDBY);
					
}	








void _ISRFAST __attribute__((interrupt, auto_psv)) _INT1Interrupt(void)

{       
	if(PHY_IRQ0 && PHY_IRQ0_En)
    {   
			if(RF_Mode == RF_RECEIVER)
					RSSIRegVal = (RegisterRead(REG_RSSIVALUE)>>1);
			else
				IRQ0_Received = TRUE; 
			PHY_IRQ0 = 0;    	
    }

		return;
}    		

void _ISRFAST __attribute__((interrupt, auto_psv)) _INT2Interrupt(void)
{
if(PHY_IRQ1 && PHY_IRQ1_En)
		{
		if(Data_Mode == DATAMODE_CONTINUOUS)
			{
				DATA_PIN = RandomBuffer[Data_out];
				Data_out= Data_out+1;
				if(Data_out == 100) Data_out = 0;
			}
		else
			{
				IRQ1_Received = TRUE;
			}
				PHY_IRQ1 = 0;
				return;
		}
	
}



