
#include "spi.h"

void SPIPut(BYTE v)
{
    BYTE dummy;
    
		//if not a PIC32 MCU
        IFS0bits.SPI1IF = 0;
		//Clear the SPIxIF bit in the respective IFSx register
        dummy = SPI1BUF;
		//read the value before writing to avoid overflow bit setting
        SPI1BUF = v;
		//write in to buffer the new value
        while(IFS0bits.SPI1IF == 0){}
		//wait until interrupt is set
}



BYTE SPIGet(void)
{
	//for other PIC processors (PIC24, dsPIC33, dsPIC30 etc)
        SPIPut(0x00);
	//put dummy value for transmit and wait until transmit is complete
        return SPI1BUF;
	//return the SPI1BUF value to the calling function (reads the data from the other SPI device)
}


