
#include "usb.h"
#include "usb_host_hid.h"
#include "system_usb.h"
#include "app_host_hid_keyboard.h"

#include "text.h"

#include "init_global.h"
#include "main.h"

#include <pps.h>
#include <stdint.h>
#include <stdbool.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <string.h>
#include <assert.h>
#include "system.h"
#include "ffconf.h"
#include "ff.h"

#define KB_SIZE     16

/* Pointer characters and searches */



T2IP = 7;
OC4IP = 7;
OC3IP = 7;
 	//void uitoa(WORD Value, BYTE* Buffer);

enum disk_command {clear, open_dir, open_file, write_file, scroll, dict, index, data, senses, extract, print, parse_index1};  
enum disk_goto {blank, read_dir, close_dir, read_file, close_file, create_file, read_file1};



void PIN_MANAGER_Initialize (void);




int getKeyCode (char *c);
int getLineCode (char *c);
unsigned char max_rows;
unsigned char min_rows;
unsigned char dictionary = 0; 



int main(void)
{ 
SYSTEM_Initialize(); /// fatfs 
PIN_MANAGER_Initialize (); 



SYSTEM_In(SYSTEM_STATE_USB_HOST);
SYSTEM_In(SYSTEM_STATE_USB_HOST_HID_KEYBOARD);
//Initialize the stack
USBHostInit(0);    
APP_HostHIDKeyboardInitialize();


InitVideo();    // start the state machines
Clrscr();

char disk_command=0;
char disk_goto=0;


unsigned char KeyBuffer [ KB_SIZE]; // declar keyboard buffer
unsigned char Directory [ KB_SIZE]; //

volatile int KBR, KBW; // head and tail or write and read pointers
KBR = 0;
KBW = 0;
 
unsigned char LineBuffer [ KB_SIZE]; // declar keyboard buffer
volatile int LR, LW; // head and tail or write and read pointers
LR = 0;
LW = 0;

 
unsigned char File_name [ KB_SIZE]; // 


memset(KeyBuffer, 0, sizeof KeyBuffer); // reset the array buffer at start up!! leave this here
 // for these, see PIC32, capturing inputs, keyboar

// Definitions
         int getKeyCode (char *c)
        {
            if ( KBR == KBW)
            return FALSE;// else buffer contains at least one key code
            *c = KeyBuffer[KBR++]; // extract the first key code
            KBR %= KB_SIZE; //wrap around the pionter 
            return TRUE;         
        } // end getKeyCode

         int getLineCode (char *c)
        {
            if ( LR == LW)
            return FALSE; // else buffer contains at least one key code
            *c = LineBuffer[LR++]; // extract the first key code
            LR %= KB_SIZE; //wrap around the pionter 
            return TRUE;         
        } // end getKeyCode  




         
         
         
while(1)
{
USBHostTasks();
USBHostHIDTasks();
APP_HostHIDKeyboardTasks(); 



        // reading keys
     if(global_var_1)// write to the buffer
     {
        KeyBuffer [ KBW] = global_var_1; // write in
        if(( KBW+1)%KB_SIZE !=KBR)        // check if buffer full
        KBW++; // else increment pointer
        KBW %= KB_SIZE; // wrap around
        global_var_1 = 0; 
     }





         if(enter == 1 && disk_command == clear) // ENTER IS PRESSED AFTER STRING INPUT
         {
             global_var_1 = 0; 
             enter = 0; 
             getKeyCode(KeyBuffer);
          
             
             

             
                           if (!strcmp( KeyBuffer, "open")) // use this c function to compare, negative
              {
                                   memset(KeyBuffer, 0, sizeof KeyBuffer); // reset the array buffer
                                        KBR = 0; // must reset these
                                        KBW = 0; // must reset these, or, buffer is spoiled
                                        cx = 0; 
                                        cy ++;
                                        putsV("Which File?>");  
                                        disk_command = open_file; // reqest directory on enter  
              }
             
                    memset(KeyBuffer, 0, sizeof KeyBuffer); // reset the array buffer
                    KBR = 0; // must reset these
                    KBW = 0; // must reset these, or, buffer is spoiled

}






             if(enter == 1 && disk_command == open_file) // OPEN A FILE AND READ IT, WITH SCROLLING
             {
                                        global_var_1 = 0; 
                                        enter = 0; 
                                        getKeyCode(KeyBuffer);
                                        putsV(&KeyBuffer);  
                                        memcpy (File_name, KeyBuffer, KB_SIZE);   /// fill Directory
                                        disk_command = clear;
                                        disk_goto=read_file; //to to the function 
             }   



         if(delete == 1 && disk_command == scroll) // scroll the read screen    SCROLLING SCROLLING
        {
            do_not_scroll = 0;
            delete = 0; 
            disk_goto = read_file;
            //disk_command =clear;
            if(min_rows == 0);
            if(min_rows> 0)
            {
            max_rows--;
            min_rows--;
            }
            // go to another reas
        }
        if(enter == 1 && disk_command == scroll)
        {
            enter = 0; 
            disk_goto = read_file;
         //   disk_command = clear;

            if(max_rows > end_file)
            {
            max_rows--;
            min_rows--;              
            }
            else
            max_rows++;
            min_rows++;
        }   

// CARRY OUT THE MAIN SCREEN INPUT COMMAND



if (disk_goto == read_file) // open file and read it - only in the front drive, not 
      {
    char buffer[1000] = { 0 };
    const char text1[1000]; // characters in the buffer
    unsigned int numRead = 0;    // number of bytes read from file.          
//    char line[100]; /* Line buffer */
    FATFS drive;
    FIL file1;           
    SYSTEM_Initialize(); /// fatfs        
    global_var_1 = 0;
    if(f_mount(&drive,"",0) == FR_INVALID_DRIVE) 
    {
    putsV("Invalid file system!\r");     
    }
    cy++;
    cx = 0; 

    f_open(&file1, &File_name, FA_READ); 
    // Rewind the file pointer to the start!
    f_lseek(&file1, 0);
    f_read(&file1, &buffer, sizeof(text1), &numRead); // un comment to read whole file unformatted

    if(max_rows == 0)
    {
    max_rows = 21;
    min_rows = 0; 
    }
    
    ClearScreen();
    Home();

    putsV1(&buffer, max_rows, min_rows);  
    disk_goto = clear;
    disk_command = scroll;

} //









}

}//end main






/****************************************************************************
  Function:
    bool USB_ApplicationEventHandler( uint8_t address, USB_EVENT event,
                void *data, uint32_t size )

  Summary:
    This is the application event handler.  It is called when the stack has
    an event that needs to be handled by the application layer rather than
    by the client driver.

  Description:
    This is the application event handler.  It is called when the stack has
    an event that needs to be handled by the application layer rather than
    by the client driver.  If the application is able to handle the event, it
    returns true.  Otherwise, it returns false.

  Precondition:
    None

  Parameters:
    uint8_t address    - Address of device where event occurred
    USB_EVENT event - Identifies the event that occured
    void *data      - Pointer to event-specific data
    uint32_t size      - Size of the event-specific data

  Return Values:
    true    - The event was handled
    false   - The event was not handled

  Remarks:
    The application may also implement an event handling routine if it
    requires knowledge of events.  To do so, it must implement a routine that
    matches this function signature and define the USB_HOST_APP_EVENT_HANDLER
    macro as the name of that function.
  ***************************************************************************/
bool USB_HOST_APP_EVENT_HANDLER ( uint8_t address, USB_EVENT event, void *data, uint32_t size )
{
    switch( (int)event )
    {
        /* Standard USB host events ******************************************/
        case EVENT_VBUS_REQUEST_POWER:
        case EVENT_VBUS_RELEASE_POWER:
        case EVENT_HUB_ATTACH:
        case EVENT_UNSUPPORTED_DEVICE:
        case EVENT_CANNOT_ENUMERATE:
        case EVENT_CLIENT_INIT_ERROR:
        case EVENT_OUT_OF_MEMORY:
        case EVENT_UNSPECIFIED_ERROR:
            return true;
            break;

        /* HID Class Specific Events ******************************************/
        case EVENT_HID_RPT_DESC_PARSED:
            if(APP_HostHIDKeyboardReportParser() == true)
            {
                return true;
            }
            break;

        default:
            break;
    }

    return false;

}






































