
#ifndef ERR_H
#define	ERR_H

#ifdef	__cplusplus
extern "C" {
#endif

//****************************************************************************
//****************************************************************************
//  Section : Defines
//****************************************************************************
//****************************************************************************


// Error code definitions 
#define SUCCESS                 0 

//i2c definitions
#define I2_TIMEOUT_PERIOD       500                                       //500 ms

#define I2C_SUCCESS             0
#define I2C_ERROR               (0x21)
#define I2C_BUF_OVRFLO          (0x22)
#define WRITE_COLL              (0x23)
#define NOT_ACK                 (0x24)
#define BUS_COLL                (0x25)
#define RX_OVRFLO               (0x26)
#define HID_DESC_RET            (0x27)
#define REP_DESC_RET            (0x28)
#define I2C_TIMEOUT_ERR         (0x29)

#define ACKSTAT_bit             (1<<15)
#define BCL_bit                 (1<<10)
#define IWOL_bit                (1<<7)
#define I2COV_bit               (1<<6)

//sf.h error definitions
//error codes
#define ID_FAIL                 (0x10)
#define HID_DESC_FAIL           (0x11)
#define RPT_DESC_FAIL           (0x12)
#define REP_PARS_FAIL           (0x14)
#define NO_EOC_FAIL             (0x15)
#define RESET_FAIL              (0x16)
#define POWER_ON_FAIL           (0x17)
#define GET_FEAT_FAIL           (0x18)
#define SET_FEAT_FAIL           (0x19)
#define SET_RPT_FAIL            (0x1A)
#define SLEEP_CMD_FAIL          (0x1B)
#define HID_GET_RPT_INPT_FAIL   (0x1C)
#define HID_GET_RPT_FEAT_FAIL   (0x1D)
#define WAKE_CMD_FAIL           (0x1E)
   
#define HID_INT_FAIL            (0x31)
#define VREG_ACCESS_ERR         (0x32)
#define VREG_OFFSET_ERR         (0x33)

#define FLSH_INFO_ERR           (0x41)
#define FLSH_WRITE_ERR          (0x42)
#define FLSH_VERIFY_ERR         (0x43)
#define FLSH_CRC_ERR            (0x44)

#define DIAG_INFO_ERR           (0x51)
#define DIAG_CALIBRATE_ERR      (0x52)
//****************************************************************************
//****************************************************************************
//  Section : Function Declarations
//****************************************************************************
//****************************************************************************

void i2cIO_error(UINT8);
void error_handler( char *, UINT8, UINT8);
void StartI2CTimer();                                               //use timer2 interrupt to recover from unresponsive i2c transactions
void StopI2CTimer();

#ifdef	__cplusplus
}
#endif

#endif	/* ERR_H */

