
#include <xc.h>
#include "pin_manager.h"

/**
    void PIN_MANAGER_Initialize(void)
*/
void PIN_MANAGER_Initialize(void)
{
//    /****************************************************************************
//     * Setting the Output Latch SFR(s)
//     ***************************************************************************/
//    LATA = 0x0000;
//    LATB = 0x0000;
//    LATC = 0x0000;
//    LATD = 0x0000;
//    LATE = 0x0200;
//    LATF = 0x0000;
//    LATG = 0x000C;
//
//    /****************************************************************************
//     * Setting the GPIO Direction SFR(s)
//     ***************************************************************************/
//    TRISA = 0xC680;
//    TRISB = 0xFFFF;
//    TRISC = 0xF01E;
//    TRISD = 0xFFFF;
//    TRISE = 0x01FF;
//    TRISF = 0x11DF;
//    TRISG = 0xF3C3;
//
//    /****************************************************************************
//     * Setting the Weak Pull Up and Weak Pull Down SFR(s)
//     ***************************************************************************/
//    CNPU1 = 0x0000;
//    CNPU2 = 0x0000;

//    /****************************************************************************
//     * Setting the Open Drain SFR(s)
//     ***************************************************************************/
//    ODCA = 0x0000;
//    ODCB = 0x0000;
//    ODCC = 0x0000;
//    ODCD = 0x0000;
//    ODCE = 0x0000;
//    ODCF = 0x0000;
//    ODCG = 0x0000;
//
//    /****************************************************************************
//     * Setting the Analog/Digital Configuration SFR(s)
//     ***************************************************************************/
//    AD1PCFG = 0x00C0;
//

//    /****************************************************************************
//     * Interrupt On Change for group CNEN1 - any
//     ***************************************************************************/
//	CNEN1bits.CN15IE = 1; // Pin : RD6
//
//    /****************************************************************************
//     * Interrupt On Change for group CNEN2 - any
//     ***************************************************************************/
//	CNEN2bits.CN19IE = 1; // Pin : RD13
//	CNEN2bits.CN16IE = 1; // Pin : RD7
//
//    IEC1bits.CNIE = 1; // Enable CNI interrupt 
//    
    
    
    
    
    
    
    // jason code 
    
        /****************************************************************************
     * Setting the Output Latch SFR(s)
     ***************************************************************************/
    LATA = 0x0000;
    LATB = 0x0000;

    /****************************************************************************
     * Setting the GPIO Direction SFR(s)
     ***************************************************************************/
    TRISA = 0x0017;
    TRISB = 0b1110111110111101;

    /****************************************************************************
     * Setting the Weak Pull Up and Weak Pull Down SFR(s)
     ***************************************************************************/
    CNPU1 = 0x0000;
    CNPU2 = 0x0000;

    /****************************************************************************
     * Setting the Open Drain SFR(s)
     ***************************************************************************/
    ODCA = 0x0000;
    ODCB = 0x0000;

    /****************************************************************************
     * Setting the Analog/Digital Configuration SFR(s)
     ***************************************************************************/
    AD1PCFG = 0b111000110011;
      
    
        /****************************************************************************
     * Set the PPS
     ***************************************************************************/
    __builtin_write_OSCCONL(OSCCON & 0xbf); // unlock PPS

//    RPOR0bits.RP1R = 0x0006;    //RB1->UART2:U2RTS
    RPINR0bits.INT1R = 0x0004;    //RB4->EXT_INT:INT1
    
    RPOR0bits.RP1R = 0x0005;    //RB3->UART2:U2TX
    RPINR19bits.U2RXR = 0x0000;    //RB2->UART2:U2RX
//    RPINR19bits.U2CTSR = 0x0000;    //RB0->UART2:U2CTS

    __builtin_write_OSCCONL(OSCCON | 0x40); // lock PPS
    
    /****************************************************************************
     * Interrupt On Change: any
     ***************************************************************************/
    CNEN1bits.CN11IE = 1;    //Pin : RB15
    CNEN1bits.CN12IE = 1;    //Pin : RB14
    CNEN1bits.CN15IE = 1;    //Pin : RB11
    
//    /* Initialize IOC Interrupt Handler*/
//    CN_SetInterruptHandler(&CN_CallBack);
//    
    /****************************************************************************
     * Interrupt On Change: Interrupt Enable
     ***************************************************************************/
    IFS1bits.CNIF = 0; //Clear CNI interrupt flag
    IEC1bits.CNIE = 1; //Enable CNI interrupt
    
}

// Addition for MM7150 application begin
typedef unsigned char UINT8;
typedef unsigned char BOOL;
#define TRUE 1
#define FALSE 0
#define _SW_S3_UP       0                                           //UP button
#define _SW_S6_DWN      1                                           //DOWN button
#define _SW_S5_SLCT     2                                           //SELECT button
#define _SW_S4_RST      3                                           //RESET (return to main menu) button

extern volatile UINT8 PB_EVT;                                       // Push Button press event
extern volatile BOOL DEBOUNCE;                                      // Debounce flag (initially set to FALSE, ie. NOT currently debouncing a switch closure)
// Addition for MM7150 application end

/* Interrupt service routine for the CNI interrupt. */
void __attribute__ (( interrupt, no_auto_psv )) _CNInterrupt ( void )
{
    if(IFS1bits.CNIF == 1)
    {
        // Addition for MM7150 application begin
        if (!SW_S3_GetValue() && !DEBOUNCE)                         // (s3) button press caused interrupt & not currently debouncing switch closure
        {
            PB_EVT = _SW_S3_UP;                                     // set the press variable
            DEBOUNCE = TRUE;                                        // begin the debounce period
        }
    
        if (!SW_S6_GetValue() && !DEBOUNCE)                         // (s6) button press caused interrupt & not currently debouncing switch closure
        {
            PB_EVT = _SW_S6_DWN;                                    // set the press variable
            DEBOUNCE = TRUE;                                        // begin the debounce period
        }
    
        if (!SW_S4_GetValue() && !DEBOUNCE)                         // (s4) button press caused interrupt & not currently debouncing switch closure
        {
            PB_EVT = _SW_S4_RST;                                    // set the press variable
            DEBOUNCE = TRUE;                                        // begin the debounce period
        }
        // Addition for MM7150 application end
        // Clear the flag
        IFS1bits.CNIF = 0;
    }
}
