
#include "mcc_generated_files/mcc.h"


// the lcd_write_string() command can write binary as (0b00000000) or
// write text as ("xxx")
//
// the lcd_set_cursor() command can set up text on the same page, and be used
// as often as you like, unless you clear the screen



void Lcd_Port(char a)
{
	if(a & 1)
		D4 = 1;
	else
		D4 = 0;

	if(a & 2)
		D5 = 1;
	else
		D5 = 0;

	if(a & 4)
		D6 = 1;
	else
		D6 = 0;

	if(a & 8)
		D7 = 1;
	else
		D7 = 0;
}
void Lcd_Cmd(char a)
{
	RS = 0;             // => RS = 0
	Lcd_Port(a);
	EN  = 1;             // => E = 1
        __delay_ms(4);
        EN  = 0;             // => E = 0
}

Lcd_Clear()
{
	Lcd_Cmd(0);
	Lcd_Cmd(1);
}

Lcd_Set_Cursor(char a, char b)
{
	char temp,z,y;
	if(a == 1)
	{
	  temp = 0x80 + b - 1;
		z = temp>>4;
		y = temp & 0x0F;
		Lcd_Cmd(z);
		Lcd_Cmd(y);
	}
	else if(a == 2)
	{
		temp = 0xC0 + b - 1;
		z = temp>>4;
		y = temp & 0x0F;
		Lcd_Cmd(z);
		Lcd_Cmd(y);
	}
}

Lcd_Init()
{
  Lcd_Port(0x00);
   __delay_ms(20);
  Lcd_Cmd(0x03);
	__delay_ms(5);
  Lcd_Cmd(0x03);
	__delay_ms(11);
  Lcd_Cmd(0x03);
  Lcd_Cmd(0x02);
  Lcd_Cmd(0x02);
  Lcd_Cmd(0x08);
  Lcd_Cmd(0x00);
  Lcd_Cmd(0x0C);
  Lcd_Cmd(0x00);
  Lcd_Cmd(0x06);
}

Lcd_Write_Char(char a)
{
   char temp,y;
   temp = a&0x0F;
   y = a&0xF0;
   RS = 1;             // => RS = 1
   Lcd_Port(y>>4);             //Data transfer
   EN = 1;
   __delay_us(40);
   EN = 0;
   Lcd_Port(temp);
   EN = 1;
   __delay_us(40);
   EN = 0;
}

//Sends a given string to the LCD. Will start printing from
//current cursor position.

Lcd_Write_String(char *a)
{
	int i;
	for(i=0;a[i]!='\0';i++)
	   Lcd_Write_Char(a[i]);
}

void Lcd_Shift_Right()
{
	Lcd_Cmd(0x01);
	Lcd_Cmd(0x0C);
}

void Lcd_Shift_Left()
{
	Lcd_Cmd(0x01);
	Lcd_Cmd(0x08);
}

void Lcd_Blink()
{
    Lcd_Cmd(0x0F);
}


//int lcd () // STORE THIS AS EXAMPLE OF HOW TO CREATE TEXT
// {
//  unsigned int a;
//
//  Lcd_Init();
//
//  while (1) // this is for loop, not in use
//  {
//    Lcd_Clear();
//    Lcd_Set_Cursor(1,1);
//    Lcd_Write_String("LCD Library for");
//    Lcd_Set_Cursor(2,1);
//    Lcd_Write_String("MPLAB XC8");
//    __delay_ms(2000);
//    Lcd_Clear();
//    Lcd_Set_Cursor(1,1);
//    Lcd_Write_String("Developed By");
//    Lcd_Set_Cursor(2,1);
//    Lcd_Write_String("Powell Electric");
//    __delay_ms(2000);
//    Lcd_Clear();
//    Lcd_Set_Cursor(1,1);
//    Lcd_Write_String("www.powelldoors.co.uk");
//
//    for(a=0;a<15;a++)
//    {
//        __delay_ms(300);
//        Lcd_Shift_Left();
//    }
//
//    for(a=0;a<15;a++)
//    {
//        __delay_ms(300);
//        Lcd_Shift_Right();
//    }
//
//    Lcd_Clear();
//    Lcd_Set_Cursor(2,1);
//    Lcd_Write_Char('e');
//    Lcd_Write_Char('S');
//    __delay_ms(2000);
//  }
//  return 0; // this is for loop,not in use
//}




























