
#include "system.h"
#include "spi_types.h"
#include "mcc.h"


#define CSEE        _RA4
#define TCSEE       _TRISA4
//#define SPI_MASTER  0x0120 // note, ss pin activation is for slave mode only, do your  own ss control as master
//#define SPI_ENABLE  0x8000


/*
                         Main application
 */
int main(void)
{
    // initialize the device
    SYSTEM_Initialize();
    
//    CSEE = 1;
//    spi1_open(SPI1_DEFAULT);
    
//    
    TCSEE = 0; 
    CSEE = 1;
    SPI1CON1 = 0b0000000000100000;
    SPI1STAT = 0b1000000000000000;
    
    
    
        char s[ BUF_SIZE];
     char c;  
     
    Clrscr();
    Home();
    putsU2( "Powell Electric \r\n");
    sprintf( s, "USART Demonstration %d\r\n", AD1PCFG);
    putsU2( s); 
    
    


    while (1)
    {

//  getsnU2( s, sizeof(s));

//  putsU2( s);

        *s = getch();
        putch( *s);                 
        
//  pcr();

        
//  spi1_exchangeBlock(s);
  CSEE = 0;
  spi1_exchangeBlock(s, 1);
  CSEE = 1;
 
    }

    return 1;
}






void putsU2( char *s)
{
    while ( *s)         // loop until *s == '\0' the end of the string
        putch( *s++);   // send the character and point to the next one
    putch( '\r');       // terminate with a cr / line feed
    putch( '\n');
} // putsU2






char *getsnU2( char *s, int len)
{
    char *p = s;
    do{
        *s = getch();
        putch( *s);                 // to echo the character
        
        if(( *s == BACKSPACE)&&( s>p))
        {
            putch( ' '); // overwrite last charater
            putch( BACKSPACE);
            len++;
            s--;        // back the pointer
            continue;
        }
        if( *s == '\n')             // line feed, ignore it
            continue;
        if( *s == '\r')             // end of line, end loop
            break;                  // 
        s++;                        // incr the buffer pointer
        len--;                      
    } while ( len>1 );              // until buffer full
    
    *s = '\0';                      // null terminate the string
    
    return p;                       // return the buffer pointer
}   //getsnU2


