
#include <xc.h>
#include <stdio.h>
#include "pin_manager.h"

/**
 Section: Driver Interface Function Definitions
*/
void PIN_MANAGER_Initialize (void)
{
    /****************************************************************************
     * Setting the Output Latch SFR(s)
     ***************************************************************************/
    LATA = 0x0000;
    LATB = 0b0000010000001000;

    /****************************************************************************
     * Setting the GPIO Direction SFR(s)
     ***************************************************************************/
    TRISA = 0b00111;
    TRISB = 0b1111111010100101;

    /****************************************************************************
     * Setting the Weak Pull Up and Weak Pull Down SFR(s)
     ***************************************************************************/
    CNPU1 = 0x0000;
    CNPU2 = 0x0000;

    /****************************************************************************
     * Setting the Open Drain SFR(s)
     ***************************************************************************/
    ODCA = 0x0000;
    ODCB = 0x0000;

    /****************************************************************************
     * Setting the Analog/Digital Configuration SFR(s)
     ***************************************************************************/
    AD1PCFG = 0x003F;
    
    /****************************************************************************
     * Set the PPS
     ***************************************************************************/
    __builtin_write_OSCCONL(OSCCON & 0xbf); // unlock PPS

    RPOR1bits.RP3R = 0x0003;    //RB3->UART1:U1TX
    RPINR18bits.U1CTSR = 0x0000;    //RB0->UART1:U1CTS
    RPOR0bits.RP1R = 0x0004;    //RB1->UART1:U1RTS
    RPINR18bits.U1RXR = 0x0002;    //RB2->UART1:U1RX

    
//    RPOR5bits.RP10R = 0x0005;    //RB10->UART2:U1TX
//    RPINR19bits.U2CTSR = 0x0007;    //RB7->UART2:U1CTS
//    RPOR4bits.RP8R = 0x0006;    //RB8->UART2:U1RTS
//    RPINR19bits.U2RXR = 0x0009;    //RB9->UART2:U1RX    
    
    
    RPINR20bits.SDI1R = 0x0007;    //RB7->SPI1:SDI1

    RPOR4bits.RP8R = 0x0007;    //RB8->SPI1:SDO1
    
    RPOR2bits.RP4R = 0x0008;    //RB4->SPI1:SCK1OUT


    
    __builtin_write_OSCCONL(OSCCON | 0x40); // lock PPS
}

