

#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include "mcc.h"
#include "spi_driver.h"
//#include "spi_types.h"

void (*spi1_interruptHandler)(void); 


inline void spi1_close(void)
{
    SPI1STATbits.SPIEN = 0;
}

//con1 == SPIxCON1, con2 == SPIxCON2, stat == SPIxSTAT, operation == Master/Slave
typedef struct { uint16_t con1; 
uint16_t con2; 
uint16_t stat; 
uint8_t operation;} 
spi1_configuration_t;


static const spi1_configuration_t spi1_configuration[] = {   
    { 0x01A0, 0x0000, 0x0000, 0 } ////////////////////////////con1 was originally 0132
};

bool spi1_open(spi1_modes spiUniqueConfiguration)
{
    if(!SPI1STATbits.SPIEN)
    {
        SPI1CON1 = spi1_configuration[spiUniqueConfiguration].con1;
        SPI1CON2 = spi1_configuration[spiUniqueConfiguration].con2;
        SPI1STAT = spi1_configuration[spiUniqueConfiguration].stat | 0x8000;
        
        TRISBbits.TRISB4 = spi1_configuration[spiUniqueConfiguration].operation;
        return true;
    }
    return false;
}

// Full Duplex SPI Functions
uint8_t spi1_exchangeByte(uint8_t b)
{
    SPI1BUF = b;
    while(!SPI1STATbits.SPIRBF);
//        putsU2(SPI1BUF);
    return SPI1BUF;

}

void spi1_exchangeBlock(void *block, size_t blockSize)
{
    uint8_t *data = block;
    while(blockSize--)
    {
        *data = spi1_exchangeByte(*data );
        data++;
    }
}

// Half Duplex SPI Functions
void spi1_writeBlock(void *block, size_t blockSize)
{
    uint8_t *data = block;
    while(blockSize--)
    {
        spi1_exchangeByte(*data++);
    }
}

void spi1_readBlock(void *block, size_t blockSize)
{
    uint8_t *data = block;
    while(blockSize--)
    {
        *data++ = spi1_exchangeByte(0);
    }
}

void spi1_writeByte(uint8_t byte)
{
    SPI1BUF = byte;
}

uint8_t spi1_readByte(void)
{
    return SPI1BUF;
}
